/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.middleware.ObservabilityHelper;
import com.microsoft.kiota.http.middleware.options.HeadersInspectionOption;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kotlin.Pair;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeadersInspectionHandler
implements Interceptor {
    private final HeadersInspectionOption options;

    public HeadersInspectionHandler() {
        this(new HeadersInspectionOption());
    }

    public HeadersInspectionHandler(@Nonnull HeadersInspectionOption options) {
        this.options = Objects.requireNonNull(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Objects.requireNonNull(chain, "parameter chain cannot be null");
        Request request = chain.request();
        HeadersInspectionOption inspectionOption = (HeadersInspectionOption)request.tag(HeadersInspectionOption.class);
        if (inspectionOption == null) {
            inspectionOption = this.options;
        }
        Span span = ObservabilityHelper.getSpanForRequest(request, "HeadersInspectionHandler_Intercept");
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.headersInspection.enable", true);
        }
        try {
            if (span != null) {
                request = request.newBuilder().tag(Span.class, (Object)span).build();
            }
            if (inspectionOption.getInspectRequestHeaders()) {
                for (Pair header : request.headers()) {
                    HashSet<String> value = new HashSet<String>();
                    value.add((String)header.getSecond());
                    inspectionOption.getRequestHeaders().put((String)header.getFirst(), (Set<String>)value);
                }
            }
            Response response = chain.proceed(request);
            if (inspectionOption.getInspectResponseHeaders()) {
                for (Pair header : response.headers()) {
                    HashSet<String> value = new HashSet<String>();
                    value.add((String)header.getSecond());
                    inspectionOption.getResponseHeaders().put((String)header.getFirst(), (Set<String>)value);
                }
            }
            Response response2 = response;
            return response2;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
    }
}

