/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.EmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;

public record TextEmbeddingByteResults(List<Embedding> embeddings) implements TextEmbeddingResults<Embedding>
{
    public static final String NAME = "text_embedding_service_byte_results";
    public static final String TEXT_EMBEDDING_BYTES = "text_embedding_bytes";

    public TextEmbeddingByteResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Embedding::new));
    }

    @Override
    public int getFirstEmbeddingSize() {
        if (this.embeddings.isEmpty()) {
            throw new IllegalStateException("Embeddings list is empty");
        }
        return this.embeddings.get(0).values().length;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).array(TEXT_EMBEDDING_BYTES, this.embeddings.iterator());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> new MlTextEmbeddingResults(TEXT_EMBEDDING_BYTES, embedding.toDoubleArray(), false)).toList();
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        LegacyTextEmbeddingResults legacyEmbedding = new LegacyTextEmbeddingResults(this.embeddings.stream().map(embedding -> new LegacyTextEmbeddingResults.Embedding(embedding.toFloatArray())).toList());
        return List.of(legacyEmbedding);
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TEXT_EMBEDDING_BYTES, this.embeddings);
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextEmbeddingByteResults that = (TextEmbeddingByteResults)o;
        return Objects.equals(this.embeddings, that.embeddings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.embeddings);
    }

    public record Embedding(byte[] values, int[] sumMergedValues, int numberOfMergedEmbeddings) implements Writeable,
    ToXContentObject,
    EmbeddingResults.Embedding<Embedding>
    {
        public static final String EMBEDDING = "embedding";

        public Embedding(byte[] values) {
            this(values, null, 1);
        }

        public Embedding(StreamInput in) throws IOException {
            this(in.readByteArray());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByteArray(this.values);
        }

        public static Embedding of(List<Byte> embeddingValuesList) {
            byte[] embeddingValues = new byte[embeddingValuesList.size()];
            for (int i = 0; i < embeddingValuesList.size(); ++i) {
                embeddingValues[i] = embeddingValuesList.get(i);
            }
            return new Embedding(embeddingValues);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(EMBEDDING);
            for (byte value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        float[] toFloatArray() {
            float[] floatArray = new float[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                floatArray[i] = Byte.valueOf(this.values[i]).floatValue();
            }
            return floatArray;
        }

        double[] toDoubleArray() {
            double[] doubleArray = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                doubleArray[i] = Byte.valueOf(this.values[i]).doubleValue();
            }
            return doubleArray;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Embedding embedding = (Embedding)o;
            return Arrays.equals(this.values, embedding.values);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        public Embedding merge(Embedding embedding) {
            byte[] newValues = new byte[this.values.length];
            int[] newSumMergedValues = new int[this.values.length];
            int newNumberOfMergedEmbeddings = this.numberOfMergedEmbeddings + embedding.numberOfMergedEmbeddings;
            for (int i = 0; i < this.values.length; ++i) {
                newSumMergedValues[i] = (this.numberOfMergedEmbeddings == 1 ? this.values[i] : this.sumMergedValues[i]) + (embedding.numberOfMergedEmbeddings == 1 ? embedding.values[i] : embedding.sumMergedValues[i]);
                newValues[i] = (byte)((newSumMergedValues[i] + newNumberOfMergedEmbeddings / 2) / newNumberOfMergedEmbeddings);
            }
            return new Embedding(newValues, newSumMergedValues, newNumberOfMergedEmbeddings);
        }

        @Override
        public BytesReference toBytesRef(XContent xContent) throws IOException {
            XContentBuilder builder = XContentBuilder.builder(xContent);
            builder.startArray();
            for (byte value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            return BytesReference.bytes(builder);
        }
    }
}

