/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    public static final NodeFeature SYNTHETIC_SOURCE_KEEP_FEATURE = new NodeFeature("mapper.synthetic_source_keep", true);
    public static final String SYNTHETIC_SOURCE_KEEP_PARAM = "synthetic_source_keep";
    public static final Setting<SourceKeepMode> SYNTHETIC_SOURCE_KEEP_INDEX_SETTING = Setting.enumSetting(SourceKeepMode.class, settings -> {
        IndexMode indexMode = IndexSettings.MODE.get((Settings)settings);
        if (indexMode == IndexMode.LOGSDB) {
            return SourceKeepMode.ARRAYS.toString();
        }
        return SourceKeepMode.NONE.toString();
    }, "index.mapping.synthetic_source_keep", value -> {
        if (value == SourceKeepMode.ALL) {
            throw new IllegalArgumentException("index.mapping.synthetic_source_keep can't be set to [" + String.valueOf(value) + "]");
        }
    }, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    private final String leafName;
    private static final StringLiteralDeduplicator fieldNameStringDeduplicator = new StringLiteralDeduplicator();
    private static final Map<FieldType, FieldType> fieldTypeDeduplicator = new ConcurrentHashMap<FieldType, FieldType>();

    public Mapper(String leafName) {
        Objects.requireNonNull(leafName);
        this.leafName = Mapper.internFieldName(leafName);
    }

    public final String leafName() {
        return this.leafName;
    }

    public abstract String fullPath();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1, MapperMergeContext var2);

    public abstract void validate(MappingLookup var1);

    public String toString() {
        return Strings.toString(this);
    }

    public static String internFieldName(String fieldName) {
        return fieldNameStringDeduplicator.deduplicate(fieldName);
    }

    public static FieldType freezeAndDeduplicateFieldType(FieldType fieldType) {
        fieldType.freeze();
        Map<String, String> attributes = fieldType.getAttributes();
        if (attributes != null && !attributes.isEmpty() || fieldType.getClass() != FieldType.class) {
            return fieldType;
        }
        if (fieldTypeDeduplicator.size() > 1000) {
            fieldTypeDeduplicator.clear();
        }
        return fieldTypeDeduplicator.computeIfAbsent(fieldType, Function.identity());
    }

    public abstract int getTotalFieldsCount();

    public final boolean supportStoringArrayOffsets() {
        return this.getOffsetFieldName() != null;
    }

    public String getOffsetFieldName() {
        return null;
    }

    public static enum SourceKeepMode {
        NONE("none"),
        ARRAYS("arrays"),
        ALL("all");

        private final String name;

        private SourceKeepMode(String name) {
            this.name = name;
        }

        static SourceKeepMode from(String input) {
            if (input == null) {
                input = "null";
            }
            if (input.equals(SourceKeepMode.NONE.name)) {
                return NONE;
            }
            if (input.equals(SourceKeepMode.ALL.name)) {
                return ALL;
            }
            if (input.equals(SourceKeepMode.ARRAYS.name)) {
                return ARRAYS;
            }
            throw new IllegalArgumentException("Unknown synthetic_source_keep value [" + input + "], accepted values are [" + String.join((CharSequence)",", Arrays.stream(SourceKeepMode.values()).map(SourceKeepMode::toString).toList()) + "]");
        }

        public String toString() {
            return this.name;
        }

        public void toXContent(XContentBuilder builder) throws IOException {
            builder.field(Mapper.SYNTHETIC_SOURCE_KEEP_PARAM, this.name);
        }
    }

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, MappingParserContext var3) throws MapperParsingException;

        default public boolean supportsVersion(IndexVersion indexCreatedVersion) {
            return indexCreatedVersion.onOrAfter(IndexVersions.MINIMUM_COMPATIBLE);
        }
    }

    public static abstract class Builder {
        private String leafName;

        protected Builder(String leafName) {
            this.leafName = leafName;
        }

        public final String leafName() {
            return this.leafName;
        }

        public abstract Mapper build(MapperBuilderContext var1);

        void setLeafName(String leafName) {
            this.leafName = leafName;
        }
    }
}

