/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.es818.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.es818.RandomAccessBinarizedByteVectorValues;

abstract class OffHeapBinarizedVectorValues
extends BinarizedByteVectorValues
implements RandomAccessBinarizedByteVectorValues {
    final int dimension;
    final int size;
    final int numBytes;
    final VectorSimilarityFunction similarityFunction;
    final FlatVectorsScorer vectorsScorer;
    final IndexInput slice;
    final byte[] binaryValue;
    final ByteBuffer byteBuffer;
    final int byteSize;
    private int lastOrd = -1;
    final float[] correctiveValues;
    int quantizedComponentSum;
    final OptimizedScalarQuantizer binaryQuantizer;
    final float[] centroid;
    final float centroidDp;
    private final int discretizedDimensions;

    OffHeapBinarizedVectorValues(int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer quantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.similarityFunction = similarityFunction;
        this.vectorsScorer = vectorsScorer;
        this.slice = slice;
        this.centroid = centroid;
        this.centroidDp = centroidDp;
        this.numBytes = BQVectorUtils.discretize(dimension, 64) / 8;
        this.correctiveValues = new float[3];
        this.byteSize = this.numBytes + 12 + 2;
        this.byteBuffer = ByteBuffer.allocate(this.numBytes);
        this.binaryValue = this.byteBuffer.array();
        this.binaryQuantizer = quantizer;
        this.discretizedDimensions = BQVectorUtils.discretize(dimension, 64);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.binaryValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = Short.toUnsignedInt(this.slice.readShort());
        this.lastOrd = targetOrd;
        return this.binaryValue;
    }

    @Override
    public int discretizedDimensions() {
        return this.discretizedDimensions;
    }

    @Override
    public float getCentroidDP() {
        return this.centroidDp;
    }

    @Override
    public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms() {
        return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
    }

    @Override
    public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = Short.toUnsignedInt(this.slice.readShort());
        return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
    }

    @Override
    public OptimizedScalarQuantizer getQuantizer() {
        return this.binaryQuantizer;
    }

    @Override
    public float[] getCentroid() {
        return this.centroid;
    }

    @Override
    public IndexInput getSlice() {
        return this.slice;
    }

    @Override
    public int getVectorByteLength() {
        return this.numBytes;
    }

    static OffHeapBinarizedVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, OptimizedScalarQuantizer binaryQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, float[] centroid, float centroidDp, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty()) {
            return new EmptyOffHeapVectorValues(dimension, similarityFunction, vectorsScorer);
        }
        assert (centroid != null);
        IndexInput bytesSlice = vectorData.slice("quantized-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, centroid, centroidDp, binaryQuantizer, vectorData, similarityFunction, vectorsScorer, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        private int doc = -1;

        EmptyOffHeapVectorValues(int dimension, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer) {
            super(dimension, 0, null, Float.NaN, null, similarityFunction, vectorsScorer, null);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public byte[] vectorValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DenseOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] target) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        private int doc = -1;

        DenseOffHeapVectorValues(int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer binaryQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, slice);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.vectorValue(this.doc);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) {
            assert (this.docID() < target);
            if (target >= this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.centroid, this.centroidDp, this.binaryQuantizer, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            final DenseOffHeapVectorValues copy = this.copy();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (RandomAccessVectorValues)copy, target);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(copy.doc);
                }

                @Override
                public DocIdSetIterator iterator() {
                    return copy;
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer binaryQuantizer, IndexInput dataIn, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) throws IOException {
            super(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, slice);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.vectorValue(this.disi.index());
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            return this.disi.advance(target);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.centroid, this.centroidDp, this.binaryQuantizer, this.dataIn, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            final SparseOffHeapVectorValues copy = this.copy();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (RandomAccessVectorValues)copy, target);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(copy.disi.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return copy;
                }
            };
        }
    }
}

