/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.bn.BengaliAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.et.EstonianAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lt.LithuanianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sr.SerbianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.analysis.util.CSVUtil;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.synonyms.PagedResult;
import org.elasticsearch.synonyms.SynonymRule;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;

public class Analysis {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(Analysis.class);
    private static final Logger logger = LogManager.getLogger(Analysis.class);
    private static final Map<String, Set<?>> NAMED_STOP_WORDS = Map.ofEntries(Map.entry("_arabic_", ArabicAnalyzer.getDefaultStopSet()), Map.entry("_armenian_", ArmenianAnalyzer.getDefaultStopSet()), Map.entry("_basque_", BasqueAnalyzer.getDefaultStopSet()), Map.entry("_bengali_", BengaliAnalyzer.getDefaultStopSet()), Map.entry("_brazilian_", BrazilianAnalyzer.getDefaultStopSet()), Map.entry("_bulgarian_", BulgarianAnalyzer.getDefaultStopSet()), Map.entry("_catalan_", CatalanAnalyzer.getDefaultStopSet()), Map.entry("_czech_", CzechAnalyzer.getDefaultStopSet()), Map.entry("_danish_", DanishAnalyzer.getDefaultStopSet()), Map.entry("_dutch_", DutchAnalyzer.getDefaultStopSet()), Map.entry("_english_", EnglishAnalyzer.getDefaultStopSet()), Map.entry("_estonian_", EstonianAnalyzer.getDefaultStopSet()), Map.entry("_finnish_", FinnishAnalyzer.getDefaultStopSet()), Map.entry("_french_", FrenchAnalyzer.getDefaultStopSet()), Map.entry("_galician_", GalicianAnalyzer.getDefaultStopSet()), Map.entry("_german_", GermanAnalyzer.getDefaultStopSet()), Map.entry("_greek_", GreekAnalyzer.getDefaultStopSet()), Map.entry("_hindi_", HindiAnalyzer.getDefaultStopSet()), Map.entry("_hungarian_", HungarianAnalyzer.getDefaultStopSet()), Map.entry("_indonesian_", IndonesianAnalyzer.getDefaultStopSet()), Map.entry("_irish_", IrishAnalyzer.getDefaultStopSet()), Map.entry("_italian_", ItalianAnalyzer.getDefaultStopSet()), Map.entry("_latvian_", LatvianAnalyzer.getDefaultStopSet()), Map.entry("_lithuanian_", LithuanianAnalyzer.getDefaultStopSet()), Map.entry("_norwegian_", NorwegianAnalyzer.getDefaultStopSet()), Map.entry("_persian_", PersianAnalyzer.getDefaultStopSet()), Map.entry("_portuguese_", PortugueseAnalyzer.getDefaultStopSet()), Map.entry("_romanian_", RomanianAnalyzer.getDefaultStopSet()), Map.entry("_russian_", RussianAnalyzer.getDefaultStopSet()), Map.entry("_serbian_", SerbianAnalyzer.getDefaultStopSet()), Map.entry("_sorani_", SoraniAnalyzer.getDefaultStopSet()), Map.entry("_spanish_", SpanishAnalyzer.getDefaultStopSet()), Map.entry("_swedish_", SwedishAnalyzer.getDefaultStopSet()), Map.entry("_thai_", ThaiAnalyzer.getDefaultStopSet()), Map.entry("_turkish_", TurkishAnalyzer.getDefaultStopSet()));

    public static void checkForDeprecatedVersion(String name, Settings settings) {
        String sVersion = settings.get("version");
        if (sVersion != null) {
            DEPRECATION_LOGGER.warn(DeprecationCategory.ANALYSIS, "analyzer.version", "Setting [version] on analysis component [" + name + "] has no effect and is deprecated", new Object[0]);
        }
    }

    public static CharArraySet parseStemExclusion(Settings settings, CharArraySet defaultStemExclusion) {
        String value = settings.get("stem_exclusion");
        if ("_none_".equals(value)) {
            return CharArraySet.EMPTY_SET;
        }
        List<String> stemExclusion = settings.getAsList("stem_exclusion", null);
        if (stemExclusion != null) {
            return new CharArraySet(stemExclusion, false);
        }
        return defaultStemExclusion;
    }

    public static CharArraySet parseWords(Environment env, Settings settings, String name, CharArraySet defaultWords, Map<String, Set<?>> namedWords, boolean ignoreCase) {
        String value = settings.get(name);
        if (value != null) {
            if ("_none_".equals(value)) {
                return CharArraySet.EMPTY_SET;
            }
            return Analysis.resolveNamedWords(settings.getAsList(name), namedWords, ignoreCase);
        }
        List<String> pathLoadedWords = Analysis.getWordList(env, settings, name);
        if (pathLoadedWords != null) {
            return Analysis.resolveNamedWords(pathLoadedWords, namedWords, ignoreCase);
        }
        return defaultWords;
    }

    public static CharArraySet parseCommonWords(Environment env, Settings settings, CharArraySet defaultCommonWords, boolean ignoreCase) {
        return Analysis.parseWords(env, settings, "common_words", defaultCommonWords, NAMED_STOP_WORDS, ignoreCase);
    }

    public static CharArraySet parseArticles(Environment env, Settings settings) {
        boolean articlesCase = settings.getAsBoolean("articles_case", false);
        return Analysis.parseWords(env, settings, "articles", null, null, articlesCase);
    }

    public static CharArraySet parseStopWords(Environment env, Settings settings, CharArraySet defaultStopWords) {
        boolean stopwordsCase = settings.getAsBoolean("stopwords_case", false);
        return Analysis.parseStopWords(env, settings, defaultStopWords, stopwordsCase);
    }

    public static CharArraySet parseStopWords(Environment env, Settings settings, CharArraySet defaultStopWords, boolean ignoreCase) {
        return Analysis.parseWords(env, settings, "stopwords", defaultStopWords, NAMED_STOP_WORDS, ignoreCase);
    }

    private static CharArraySet resolveNamedWords(Collection<String> words, Map<String, Set<?>> namedWords, boolean ignoreCase) {
        if (namedWords == null) {
            return new CharArraySet(words, ignoreCase);
        }
        CharArraySet setWords = new CharArraySet(words.size(), ignoreCase);
        for (String word : words) {
            if (namedWords.containsKey(word)) {
                setWords.addAll((Collection)namedWords.get(word));
                continue;
            }
            setWords.add(word);
        }
        return setWords;
    }

    public static CharArraySet getWordSet(Environment env, Settings settings, String settingsPrefix) {
        List<String> wordList = Analysis.getWordList(env, settings, settingsPrefix);
        if (wordList == null) {
            return null;
        }
        boolean ignoreCase = settings.getAsBoolean(settingsPrefix + "_case", false);
        return new CharArraySet(wordList, ignoreCase);
    }

    public static List<String> getWordList(Environment env, Settings settings, String settingPrefix) {
        return Analysis.getWordList(env, settings, settingPrefix + "_path", settingPrefix, true);
    }

    public static List<String> getWordList(Environment env, Settings settings, String settingPath, String settingList, boolean removeComments) {
        String wordListPath = settings.get(settingPath, null);
        if (wordListPath == null) {
            List<String> explicitWordList = settings.getAsList(settingList, null);
            if (explicitWordList == null) {
                return null;
            }
            return explicitWordList;
        }
        Path path = env.configDir().resolve(wordListPath);
        try {
            return Analysis.loadWordList(path, removeComments);
        }
        catch (CharacterCodingException ex) {
            String message = Strings.format("Unsupported character encoding detected while reading %s: %s - files must be UTF-8 encoded", settingPath, path);
            throw new IllegalArgumentException(message, ex);
        }
        catch (IOException ioe) {
            String message = Strings.format("IOException while reading %s: %s", settingPath, path);
            throw new IllegalArgumentException(message, ioe);
        }
        catch (SecurityException ace) {
            throw new IllegalArgumentException(Strings.format("Access denied trying to read file %s: %s", settingPath, path), ace);
        }
    }

    public static List<String> getWordList(Environment env, Settings settings, String settingPath, String settingList, String settingLenient, boolean removeComments, boolean checkDuplicate) {
        boolean deduplicateDictionary = settings.getAsBoolean(settingLenient, false);
        List<String> ruleList = Analysis.getWordList(env, settings, settingPath, settingList, removeComments);
        if (ruleList != null && !ruleList.isEmpty() && checkDuplicate) {
            return Analysis.deDuplicateRules(ruleList, !deduplicateDictionary);
        }
        return ruleList;
    }

    private static List<String> deDuplicateRules(List<String> ruleList, boolean failOnDuplicate) {
        HashSet<String> duplicateKeys = new HashSet<String>();
        ArrayList<String> deduplicatedList = new ArrayList<String>();
        for (int lineNum = 0; lineNum < ruleList.size(); ++lineNum) {
            String line = ruleList.get(lineNum);
            if (!line.startsWith("#")) {
                String[] values = CSVUtil.parse(line);
                if (!duplicateKeys.add(values[0])) {
                    if (failOnDuplicate) {
                        throw new IllegalArgumentException("Found duplicate term [" + values[0] + "] in user dictionary at line [" + (lineNum + 1) + "]");
                    }
                    logger.warn("Ignoring duplicate term [" + values[0] + "] in user dictionary at line [" + (lineNum + 1) + "]");
                    continue;
                }
                deduplicatedList.add(line);
                continue;
            }
            deduplicatedList.add(line);
        }
        return Collections.unmodifiableList(deduplicatedList);
    }

    private static List<String> loadWordList(Path path, boolean removeComments) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader br = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String word;
            while ((word = br.readLine()) != null) {
                if (!Strings.hasText(word) || removeComments && word.startsWith("#")) continue;
                result.add(word.trim());
            }
        }
        return result;
    }

    public static Reader getReaderFromFile(Environment env, String filePath, String settingPrefix) {
        if (filePath == null) {
            return null;
        }
        Path path = env.configDir().resolve(filePath);
        try {
            return Files.newBufferedReader(path, StandardCharsets.UTF_8);
        }
        catch (CharacterCodingException ex) {
            String message = String.format(Locale.ROOT, "Unsupported character encoding detected while reading %s_path: %s files must be UTF-8 encoded", settingPrefix, path.toString());
            throw new IllegalArgumentException(message, ex);
        }
        catch (IOException ioe) {
            String message = String.format(Locale.ROOT, "IOException while reading %s_path: %s", settingPrefix, path.toString());
            throw new IllegalArgumentException(message, ioe);
        }
    }

    public static Reader getReaderFromIndex(String synonymsSet, SynonymsManagementAPIService synonymsManagementAPIService, boolean ignoreMissing) {
        PagedResult results;
        PlainActionFuture<PagedResult<SynonymRule>> synonymsLoadingFuture = new PlainActionFuture<PagedResult<SynonymRule>>();
        synonymsManagementAPIService.getSynonymSetRules(synonymsSet, synonymsLoadingFuture);
        try {
            results = synonymsLoadingFuture.actionGet();
        }
        catch (Exception e) {
            if (!ignoreMissing) {
                throw e;
            }
            boolean notFound = e instanceof ResourceNotFoundException;
            String message = String.format(Locale.ROOT, "Synonyms set %s %s. Synonyms will not be applied to search results on indices that use this synonym set", synonymsSet, notFound ? "not found" : "could not be loaded");
            if (notFound) {
                logger.warn(message);
            } else {
                logger.error(message, (Throwable)e);
            }
            results = new PagedResult(0L, (Writeable[])new SynonymRule[0]);
        }
        SynonymRule[] synonymRules = (SynonymRule[])results.pageResults();
        StringBuilder sb = new StringBuilder();
        for (SynonymRule synonymRule : synonymRules) {
            sb.append(synonymRule.synonyms()).append(System.lineSeparator());
        }
        return new StringReader(sb.toString());
    }
}

