/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class UserProfileHitMetadata
implements JsonpSerializable {
    private final long primaryTerm;
    private final long seqNo;
    public static final JsonpDeserializer<UserProfileHitMetadata> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserProfileHitMetadata::setupUserProfileHitMetadataDeserializer);

    private UserProfileHitMetadata(Builder builder) {
        this.primaryTerm = ApiTypeHelper.requireNonNull(builder.primaryTerm, (Object)this, "primaryTerm", 0L);
        this.seqNo = ApiTypeHelper.requireNonNull(builder.seqNo, (Object)this, "seqNo", 0L);
    }

    public static UserProfileHitMetadata of(Function<Builder, ObjectBuilder<UserProfileHitMetadata>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long primaryTerm() {
        return this.primaryTerm;
    }

    public final long seqNo() {
        return this.seqNo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("_seq_no");
        generator.write(this.seqNo);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupUserProfileHitMetadataDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(Builder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UserProfileHitMetadata> {
        private Long primaryTerm;
        private Long seqNo;

        public final Builder primaryTerm(long value) {
            this.primaryTerm = value;
            return this;
        }

        public final Builder seqNo(long value) {
            this.seqNo = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserProfileHitMetadata build() {
            this._checkSingleUse();
            return new UserProfileHitMetadata(this);
        }
    }
}

