/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;

public class DeleteLifecycleAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteLifecycleAction INSTANCE = new DeleteLifecycleAction();
    public static final String NAME = "cluster:admin/ilm/delete";

    protected DeleteLifecycleAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String policyName;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String policyName) {
            super(masterNodeTimeout, ackTimeout);
            this.policyName = policyName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.policyName = in.readString();
        }

        public String getPolicyName() {
            return this.policyName;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.policyName);
        }

        public int hashCode() {
            return Objects.hash(this.policyName);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.policyName, other.policyName);
        }

        @Override
        public String toString() {
            return Strings.format("delete lifecycle policy [%s]", this.policyName);
        }
    }
}

