/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.VectorUtil;

public class BQVectorUtils {
    private static final float EPSILON = 1.0E-4f;

    public static double sqrtNewtonRaphson(double x, double curr, double prev) {
        return curr == prev ? curr : BQVectorUtils.sqrtNewtonRaphson(x, 0.5 * (curr + x / curr), curr);
    }

    public static double constSqrt(double x) {
        return x >= 0.0 && !Double.isInfinite(x) ? BQVectorUtils.sqrtNewtonRaphson(x, x, 0.0) : Double.NaN;
    }

    public static boolean isUnitVector(float[] v) {
        double l1norm = VectorUtil.dotProduct(v, v);
        return Math.abs(l1norm - 1.0) <= (double)1.0E-4f;
    }

    public static void packAsBinary(byte[] vector, byte[] packed) {
        int i = 0;
        while (i < vector.length) {
            byte result = 0;
            for (int j = 7; j >= 0 && i < vector.length; ++i, --j) {
                assert (vector[i] == 0 || vector[i] == 1);
                result = (byte)(result | (byte)((vector[i] & 1) << j));
            }
            int index = (i + 7) / 8 - 1;
            assert (index < packed.length);
            packed[index] = result;
        }
    }

    public static int discretize(int value, int bucket) {
        return (value + (bucket - 1)) / bucket * bucket;
    }

    public static float[] pad(float[] vector, int dimensions) {
        if (vector.length >= dimensions) {
            return vector;
        }
        return ArrayUtil.growExact(vector, dimensions);
    }

    public static byte[] pad(byte[] vector, int dimensions) {
        if (vector.length >= dimensions) {
            return vector;
        }
        return ArrayUtil.growExact(vector, dimensions);
    }

    public static int popcount(byte[] d) {
        int r;
        int cnt = 0;
        int upperBound = d.length & 0xFFFFFFFC;
        for (r = 0; r < upperBound; r += 4) {
            cnt += Integer.bitCount(BitUtil.VH_NATIVE_INT.get(d, r));
        }
        while (r < d.length) {
            cnt += Integer.bitCount(d[r] & 0xFF);
            ++r;
        }
        return cnt;
    }

    public static void divideInPlace(float[] a, float b) {
        int j = 0;
        while (j < a.length) {
            int n = j++;
            a[n] = a[n] / b;
        }
    }

    public static float[] subtract(float[] a, float[] b) {
        float[] result = new float[a.length];
        BQVectorUtils.subtract(a, b, result);
        return result;
    }

    public static void subtractInPlace(float[] target, float[] other) {
        BQVectorUtils.subtract(target, other, target);
    }

    private static void subtract(float[] a, float[] b, float[] result) {
        for (int j = 0; j < a.length; ++j) {
            result[j] = a[j] - b[j];
        }
    }

    public static float norm(float[] vector) {
        float magnitude = VectorUtil.dotProduct(vector, vector);
        return (float)Math.sqrt(magnitude);
    }
}

