/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Maps {
    private static final Set<Class<?>> IMMUTABLE_MAP_CLASSES = Set.of(Collections.emptyMap().getClass(), Collections.unmodifiableMap(new HashMap()).getClass(), Map.of().getClass(), Map.of("a", "b").getClass());

    public static <K, V> Map<K, V> copyMapWithAddedEntry(Map<K, V> map, K key, V value) {
        assert (Maps.assertIsImmutableMapAndNonNullKey(map, key, value));
        assert (value != null);
        assert (!map.containsKey(key)) : "expected entry [" + String.valueOf(key) + "] to not already be present in map";
        Map.Entry[] entries = new Map.Entry[map.size() + 1];
        map.entrySet().toArray(entries);
        entries[entries.length - 1] = Map.entry(key, value);
        return Map.ofEntries(entries);
    }

    public static <K, V> Map<K, V> copyMapWithAddedOrReplacedEntry(Map<K, V> map, K key, V value) {
        V existing = map.get(key);
        if (existing == null) {
            return Maps.copyMapWithAddedEntry(map, key, value);
        }
        assert (Maps.assertIsImmutableMapAndNonNullKey(map, key, value));
        assert (value != null);
        Map.Entry[] entries = new Map.Entry[map.size()];
        boolean replaced = false;
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!replaced && entry.getKey().equals(key)) {
                entry = Map.entry(entry.getKey(), value);
                replaced = true;
            }
            entries[i++] = entry;
        }
        return Map.ofEntries(entries);
    }

    public static <K, V> Map<K, V> copyMapWithRemovedEntry(Map<K, V> map, K key) {
        assert (Maps.assertIsImmutableMapAndNonNullKey(map, key, map.get(key)));
        return map.entrySet().stream().filter(k -> !key.equals(k.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <K, V> boolean assertIsImmutableMapAndNonNullKey(Map<K, V> map, K key, V value) {
        assert (key != null);
        if (IMMUTABLE_MAP_CLASSES.contains(map.getClass())) {
            return true;
        }
        try {
            map.put(key, value);
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return true;
        }
    }

    public static <K, V> Map<K, V> ofEntries(Collection<Map.Entry<K, V>> entries) {
        Map map = Map.ofEntries((Map.Entry[])entries.toArray(Map.Entry[]::new));
        return map;
    }

    public static <K, V> boolean deepEquals(Map<K, V> left, Map<K, V> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null || left.size() != right.size()) {
            return false;
        }
        for (Map.Entry<K, V> e : left.entrySet()) {
            Map m2;
            Map m1;
            if (!right.containsKey(e.getKey())) {
                return false;
            }
            V v1 = e.getValue();
            V v2 = right.get(e.getKey());
            if (!(v1 instanceof Map && v2 instanceof Map ? !Maps.deepEquals(m1 = (Map)v1, m2 = (Map)v2) : !Objects.deepEquals(v1, v2))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, Object> flatten(Map<String, Object> map, boolean flattenArrays, boolean ordered) {
        return Maps.flatten(map, flattenArrays, ordered, null);
    }

    private static Map<String, Object> flatten(Map<String, Object> map, boolean flattenArrays, boolean ordered, String parentPath) {
        TreeMap<String, Object> flatMap = ordered ? new TreeMap() : new HashMap();
        Object prefix = parentPath != null ? parentPath + "." : "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                flatMap.putAll(Maps.flatten((Map)entry.getValue(), flattenArrays, ordered, (String)prefix + entry.getKey()));
                continue;
            }
            if (flattenArrays && entry.getValue() instanceof List) {
                flatMap.putAll(Maps.flatten((List)entry.getValue(), ordered, (String)prefix + entry.getKey()));
                continue;
            }
            flatMap.put((String)prefix + entry.getKey(), entry.getValue());
        }
        return flatMap;
    }

    private static Map<String, Object> flatten(List<Object> list, boolean ordered, String parentPath) {
        TreeMap<String, Object> flatMap = ordered ? new TreeMap() : new HashMap();
        Object prefix = parentPath != null ? parentPath + "." : "";
        for (int i = 0; i < list.size(); ++i) {
            Object cur = list.get(i);
            if (cur instanceof Map) {
                flatMap.putAll(Maps.flatten((Map)cur, true, ordered, (String)prefix + i));
                continue;
            }
            if (cur instanceof List) {
                flatMap.putAll(Maps.flatten((List)cur, ordered, (String)prefix + i));
                continue;
            }
            flatMap.put((String)prefix + i, cur);
        }
        return flatMap;
    }

    public static <T, K, V> Collector<T, ?, NavigableMap<K, V>> toUnmodifiableSortedMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key (attempted merging values " + String.valueOf(v1) + "  and " + String.valueOf(v2) + ")");
        }, () -> new TreeMap()), Collections::unmodifiableNavigableMap);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toUnmodifiableOrderedMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key (attempted merging values " + String.valueOf(v1) + "  and " + String.valueOf(v2) + ")");
        }, LinkedHashMap::new), Collections::unmodifiableMap);
    }

    public static <K, V> Map<K, V> newMapWithExpectedSize(int expectedSize) {
        return Maps.newHashMapWithExpectedSize(expectedSize);
    }

    public static <K, V> Map<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(Maps.capacity(expectedSize));
    }

    public static <K, V> Map<K, V> newConcurrentHashMapWithExpectedSize(int expectedSize) {
        return new ConcurrentHashMap(Maps.capacity(expectedSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(Maps.capacity(expectedSize));
    }

    static int capacity(int expectedSize) {
        assert (expectedSize >= 0);
        return expectedSize < 2 ? expectedSize + 1 : (int)((double)expectedSize / 0.75 + 1.0);
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> source, Function<V, V> copyValueFunction) {
        return Maps.transformValues(source, copyValueFunction);
    }

    public static <K, V1, V2> Map<K, V2> transformValues(Map<K, V1> source, Function<V1, V2> copyValueFunction) {
        Map<K, V2> copy = Maps.newHashMapWithExpectedSize(source.size());
        for (Map.Entry<K, V1> entry : source.entrySet()) {
            copy.put(entry.getKey(), copyValueFunction.apply(entry.getValue()));
        }
        return copy;
    }
}

