/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;

public class DateUtils {
    private static final DateFormatter dateOnlyFormatter = DateFormatter.forPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private static final DateFormatter dateTimeFormatter = DateFormatter.forPattern("strict_date_time").withZone(ZoneOffset.UTC);

    public static long endOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseMillis(date);
        }
        catch (IllegalArgumentException | ElasticsearchParseException ex) {
            ZonedDateTime dateTime = DateFormatters.from(dateOnlyFormatter.parse(date));
            dateTime.with(ChronoField.MILLI_OF_DAY, ChronoField.MILLI_OF_DAY.range().getMaximum());
            return dateTime.toInstant().toEpochMilli();
        }
    }

    public static long beginningOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseMillis(date);
        }
        catch (IllegalArgumentException | ElasticsearchParseException ex) {
            return DateFormatters.from(dateOnlyFormatter.parse(date)).toInstant().toEpochMilli();
        }
    }
}

