# frozen_string_literal: true

require_relative 'lib/fishwife/base'

Gem::Specification.new do |spec|
  spec.name    = 'fishwife-servlet'
  spec.version = Fishwife::VERSION
  spec.authors = ['David Kellum']
  spec.email   = ['dek-oss@gravitext.com']
  spec.license = 'Apache-2.0'

  spec.summary     = "A ruby-based Servlet bridge for Rack"
  spec.description = "A ruby-based bridge (extracted from Fishwife) allowing mounting of Rack applications into Jetty as Java servlets."
  spec.homepage    = "https://github.com/dekellum/fishwife"

  spec.required_ruby_version = Gem::Requirement.new('>= 2.5.0')
  spec.platform = 'java'

  spec.metadata["homepage_uri"] = spec.homepage
  spec.metadata["source_code_uri"] = 'https://github.com/dekellum/fishwife'

  # Specify which files should be added to the gem when it is released.
  spec.files =
    Dir.glob('lib/**/*', File::FNM_DOTMATCH).reject {|f| File.directory?(f) } +
    Dir.glob('target/*.jar')

  spec.require_paths = ["lib"]
end
