# frozen_string_literal: true
module Actastic
  module EmbeddedRecord
    extend ActiveSupport::Concern

    included do
      include ActiveModel::Validations

      include Actastic::AssociationCache
      include Actastic::Validations

      class_attribute :fields, :instance_accessor => false
    end

    class_methods do
      def embedded_in(name, inverse_of:, class_name:)
        define_method(name) { @parent }
        self.fields = class_name.constantize.schema.fields.fetch(inverse_of).fetch(:fields)
        attr_writer(*fields.keys)

        # getters should use default values
        fields.each do |field_name, field|
          define_method(field_name) do
            unless instance_variable_defined?(:"@#{field_name}")
              default_value = @parent.class.cast(field[:default].deep_dup, field[:type], field)
              instance_variable_set(:"@#{field_name}", default_value)
            end
            instance_variable_get(:"@#{field_name}")
          end
        end
      end

      def has_one(name, foreign_key:, class_name:)
        define_method(name) do
          cached_association(name) do
            class_name.constantize.find_by(:id => public_send(foreign_key))
          end
        end
      end
    end

    def new_record?
      @parent.new_record?
    end

    def initialize(parent, attributes)
      @parent = parent
      assign_attributes(attributes)
    end

    def assign_attributes(attributes)
      attributes.each do |attribute, value|
        public_send("#{attribute}=", value)
      end
    end

    def attributes
      self.class.fields.each_with_object(ActiveSupport::HashWithIndifferentAccess.new) do |(attribute, _), out|
        out[attribute] = public_send(attribute)
      end
    end
  end
end
