/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux.mips64el;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum SocketMessage implements Constant
{
    MSG_DONTWAIT(64L),
    MSG_OOB(1L),
    MSG_PEEK(2L),
    MSG_DONTROUTE(4L),
    MSG_EOR(128L),
    MSG_TRUNC(32L),
    MSG_CTRUNC(8L),
    MSG_WAITALL(256L),
    MSG_PROXY(16L),
    MSG_FIN(512L),
    MSG_SYN(1024L),
    MSG_CONFIRM(2048L),
    MSG_RST(4096L),
    MSG_ERRQUEUE(8192L),
    MSG_NOSIGNAL(16384L),
    MSG_MORE(32768L),
    MSG_FASTOPEN(0x20000000L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 0x20000000L;

    private SocketMessage(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<SocketMessage, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<SocketMessage, String> generateTable() {
            EnumMap<SocketMessage, String> map2 = new EnumMap<SocketMessage, String>(SocketMessage.class);
            map2.put(MSG_DONTWAIT, "MSG_DONTWAIT");
            map2.put(MSG_OOB, "MSG_OOB");
            map2.put(MSG_PEEK, "MSG_PEEK");
            map2.put(MSG_DONTROUTE, "MSG_DONTROUTE");
            map2.put(MSG_EOR, "MSG_EOR");
            map2.put(MSG_TRUNC, "MSG_TRUNC");
            map2.put(MSG_CTRUNC, "MSG_CTRUNC");
            map2.put(MSG_WAITALL, "MSG_WAITALL");
            map2.put(MSG_PROXY, "MSG_PROXY");
            map2.put(MSG_FIN, "MSG_FIN");
            map2.put(MSG_SYN, "MSG_SYN");
            map2.put(MSG_CONFIRM, "MSG_CONFIRM");
            map2.put(MSG_RST, "MSG_RST");
            map2.put(MSG_ERRQUEUE, "MSG_ERRQUEUE");
            map2.put(MSG_NOSIGNAL, "MSG_NOSIGNAL");
            map2.put(MSG_MORE, "MSG_MORE");
            map2.put(MSG_FASTOPEN, "MSG_FASTOPEN");
            return map2;
        }
    }
}

