# frozen_string_literal: true
module Actastic
  class NullRelation < Relation
    def count(*)
      0
    end

    def each
      enum_for(:each) { count } unless block_given?
    end

    def find_each
      enum_for(:find_each) { count } unless block_given?
    end

    private

    def retrieve(*)
      raise NotImplementedError
    end

    def search(*)
      raise NotImplementedError
    end

    def document_count(*)
      raise NotImplementedError
    end
  end
end
