# frozen_string_literal: true

module Actastic
  module Concerns
    module Coercable
      extend ActiveSupport::Concern

      def coerce_date(value)
        return value if value.is_a?(Time)
        return value.to_time if value.is_a?(Date)
        return value.to_time if value.is_a?(DateTime)
        return value.to_time if value.is_a?(ActiveSupport::TimeWithZone)

        # support date without time (YYYY-MM-DD)
        value = "#{value}T00:00:00-00:00" if value.is_a?(String) && value.size == 10

        DateTime.rfc3339(value).to_time
      rescue ArgumentError, TypeError
        raise CoercionValueException.new("Value '#{value}' cannot be parsed as a date (RFC 3339)")
      end
    end
  end
end
