# frozen_string_literal: true
module Actastic
  module AssociationCache
    extend ActiveSupport::Concern

    def reload
      super.tap do
        _actastic_association_cache.clear
      end
    end

    def _actastic_association_cache
      @_actastic_association_cache ||= {}
    end

    def cached_association(name, inverse_of: nil)
      if (out = _actastic_association_cache[name.to_sym])
        return out
      end

      instance = yield

      cache_association!(name, instance, :inverse_of => inverse_of)
    end

    def cache_association!(name, instance, inverse_of: nil)
      if instance && inverse_of
        instance._actastic_association_cache[inverse_of.to_sym] = self
      end

      _actastic_association_cache[name.to_sym] = instance
    end

    def bust_association_cache!(name)
      _actastic_association_cache.delete(name.to_sym)
    end
  end
end
