# frozen_string_literal: true
class Views::FritoPie::Invitations::Show < ::Views::Base
  needs :fp_invitation

  def view_title
    'Workplace Search'
  end

  def content
    widget(Views::FritoPie::Head::Login, :view_title => view_title)
    widget(Views::FritoPie::AuthBody, :view_title => view_title) do
      if fp_invitation.active?
        widget(
          Views::SharedTogo::AcceptInvite,
          :invitation => fp_invitation,
          :invitation_code_param => :fp_invitation_code
        )
      else
        div(:class => 'euiTextAlign euiTextAlign--center') do
          p('This invitation has expired. Please ask your Elastic Workplace Search Administrator to re-invite you or sign in.', :class => 'euiTitle euiTitle--medium')
        end
      end
    end
  end
end
