module Actastic
  class Configuration
    class NotSupportedEsVersion < StandardError; end
    class MissingEsClusterNode < StandardError; end
    class MissingEsClientError < StandardError; end
    class MissingJsonEncoderError < StandardError; end

    attr_writer :index_prefix, :es_version_support, :es_cluster_node, :json_encoder_class

    def index_prefix
      @index_prefix || '.ent-search'
    end

    def es_version_support
      raise NotSupportedEsVersion if @es_version_support.blank?

      @es_version_support
    end

    def es_cluster_node
      if @es_cluster_node.blank?
        raise MissingEsClusterNode, 'Please add ES Cluster node to Actastic initializer'
      end

      @es_cluster_node
    end

    def json_encoder_class
      if @json_encoder_class.blank? || !defined?(@json_encoder_class.constantize)
        raise MissingJsonEncoderError, 'Please add JSON encoder to Actastic initializer'
      end

      @json_encoder_class.constantize
    end
  end
end
