/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jruby.rack.RackLogger;

public class Log4jLogger
extends RackLogger.Base {
    private Logger logger;

    public Log4jLogger() {
        this.logger = Logger.getRootLogger();
    }

    public Log4jLogger(String loggerName) {
        this.setLoggerName(loggerName);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerName(String loggerName) {
        this.logger = Logger.getLogger((String)loggerName);
    }

    @Override
    public boolean isEnabled(RackLogger.Level level) {
        if (level == null) {
            return this.logger.isInfoEnabled();
        }
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isEnabledFor((Priority)Level.WARN);
            }
            case ERROR: {
                return this.logger.isEnabledFor((Priority)Level.ERROR);
            }
            case FATAL: {
                return this.logger.isEnabledFor((Priority)Level.FATAL);
            }
        }
        return this.logger.isEnabledFor((Priority)Level.ALL);
    }

    @Override
    public void log(RackLogger.Level level, String message) {
        if (level == null) {
            this.logger.info((Object)message);
            return;
        }
        switch (level) {
            case DEBUG: {
                this.logger.debug((Object)message);
            }
            case INFO: {
                this.logger.info((Object)message);
            }
            case WARN: {
                this.logger.warn((Object)message);
            }
            case ERROR: {
                this.logger.error((Object)message);
            }
            case FATAL: {
                this.logger.fatal((Object)message);
            }
        }
    }

    @Override
    public void log(RackLogger.Level level, String message, Throwable ex) {
        if (level == null) {
            this.logger.error((Object)message, ex);
            return;
        }
        switch (level) {
            case DEBUG: {
                this.logger.debug((Object)message, ex);
            }
            case INFO: {
                this.logger.info((Object)message, ex);
            }
            case WARN: {
                this.logger.warn((Object)message, ex);
            }
            case ERROR: {
                this.logger.error((Object)message, ex);
            }
            case FATAL: {
                this.logger.fatal((Object)message, ex);
            }
        }
    }

    @Override
    public RackLogger.Level getLevel() {
        if (this.logger.isEnabledFor((Priority)Level.DEBUG)) {
            return RackLogger.Level.DEBUG;
        }
        if (this.logger.isEnabledFor((Priority)Level.INFO)) {
            return RackLogger.Level.INFO;
        }
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            return RackLogger.Level.WARN;
        }
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            return RackLogger.Level.ERROR;
        }
        if (this.logger.isEnabledFor((Priority)Level.FATAL)) {
            return RackLogger.Level.FATAL;
        }
        return null;
    }
}

