/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jruby.rack.RackLogger;

public class CommonsLoggingLogger
extends RackLogger.Base {
    private Log logger;

    public CommonsLoggingLogger(String loggerName) {
        this.setLoggerName(loggerName);
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setLoggerName(String loggerName) {
        this.logger = LogFactory.getLog((String)loggerName);
    }

    @Override
    public boolean isEnabled(RackLogger.Level level) {
        if (level == null) {
            return this.logger.isInfoEnabled();
        }
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case FATAL: {
                return this.logger.isFatalEnabled();
            }
        }
        return this.logger.isTraceEnabled();
    }

    @Override
    public void log(RackLogger.Level level, String message) {
        if (level == null) {
            this.logger.info((Object)message);
            return;
        }
        switch (level) {
            case DEBUG: {
                this.logger.debug((Object)message);
            }
            case INFO: {
                this.logger.info((Object)message);
            }
            case WARN: {
                this.logger.warn((Object)message);
            }
            case ERROR: {
                this.logger.error((Object)message);
            }
            case FATAL: {
                this.logger.fatal((Object)message);
            }
        }
    }

    @Override
    public void log(RackLogger.Level level, String message, Throwable ex) {
        if (level == null) {
            this.logger.error((Object)message, ex);
            return;
        }
        switch (level) {
            case DEBUG: {
                this.logger.debug((Object)message, ex);
            }
            case INFO: {
                this.logger.info((Object)message, ex);
            }
            case WARN: {
                this.logger.warn((Object)message, ex);
            }
            case ERROR: {
                this.logger.error((Object)message, ex);
            }
            case FATAL: {
                this.logger.fatal((Object)message, ex);
            }
        }
    }

    @Override
    public RackLogger.Level getLevel() {
        if (this.logger.isDebugEnabled()) {
            return RackLogger.Level.DEBUG;
        }
        if (this.logger.isInfoEnabled()) {
            return RackLogger.Level.INFO;
        }
        if (this.logger.isWarnEnabled()) {
            return RackLogger.Level.WARN;
        }
        if (this.logger.isErrorEnabled()) {
            return RackLogger.Level.ERROR;
        }
        if (this.logger.isFatalEnabled()) {
            return RackLogger.Level.FATAL;
        }
        return null;
    }
}

