/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.jms;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jruby.rack.RackContext;
import org.jruby.rack.jms.DefaultQueueManager;
import org.jruby.rack.jms.QueueManager;
import org.jruby.rack.jms.QueueManagerFactory;

public class QueueContextListener
implements ServletContextListener {
    private QueueManagerFactory factory;

    public QueueContextListener() {
        this.factory = null;
    }

    public QueueContextListener(QueueManagerFactory qmf) {
        this.factory = qmf;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        RackContext rackContext = (RackContext)servletContext.getAttribute("rack.context");
        try {
            QueueManager qm = this.newQueueManagerFactory().newQueueManager();
            qm.init(rackContext);
            servletContext.setAttribute("rack.queue.manager", (Object)qm);
        }
        catch (Exception e) {
            servletContext.log("Error initializing queue manager:" + e.getMessage(), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        QueueManager qm = (QueueManager)event.getServletContext().getAttribute("rack.queue.manager");
        if (qm != null) {
            event.getServletContext().removeAttribute("rack.queue.manager");
            qm.destroy();
        }
    }

    private QueueManagerFactory newQueueManagerFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return new QueueManagerFactory(){

            @Override
            public QueueManager newQueueManager() {
                return new DefaultQueueManager();
            }
        };
    }
}

