/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;

public class CasDefinition {
    private TypeSystemDescription typeSystemDescription;
    private TypeSystemImpl typeSystemImpl;
    private TypePriorities typePriorities;
    private FsIndexDescription[] fsIndexDescriptions;
    private ResourceManager resourceManager;

    public CasDefinition(TypeSystemDescription aTypeSystem, TypePriorities aTypePriorities, FsIndexDescription[] aFsIndexes, ResourceManager aResourceManager, Properties aPerformanceTuningSettings) {
        this.typeSystemDescription = aTypeSystem;
        this.typePriorities = aTypePriorities;
        this.fsIndexDescriptions = aFsIndexes;
        this.resourceManager = aResourceManager;
    }

    public CasDefinition(Collection<? extends ProcessingResourceMetaData> aMetaDataToMerge, ResourceManager aResourceManager) throws ResourceInitializationException {
        TypeSystemDescription aggTypeDesc;
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> typePrioritiesList = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> fsIndexes = new ArrayList<FsIndexCollection>();
        for (ProcessingResourceMetaData processingResourceMetaData : aMetaDataToMerge) {
            if (processingResourceMetaData.getTypeSystem() != null) {
                typeSystems.add(processingResourceMetaData.getTypeSystem());
            }
            if (processingResourceMetaData.getTypePriorities() != null) {
                typePrioritiesList.add(processingResourceMetaData.getTypePriorities());
            }
            if (processingResourceMetaData.getFsIndexCollection() == null) continue;
            fsIndexes.add(processingResourceMetaData.getFsIndexCollection());
        }
        TypePriorities typePriorities = CasCreationUtils.mergeTypePriorities(typePrioritiesList, aResourceManager);
        FsIndexCollection aggIndexColl = CasCreationUtils.mergeFsIndexes(fsIndexes, aResourceManager);
        this.typeSystemDescription = aggTypeDesc = CasCreationUtils.mergeTypeSystems(typeSystems, aResourceManager);
        this.typePriorities = typePriorities;
        this.fsIndexDescriptions = aggIndexColl.getFsIndexes();
        this.resourceManager = aResourceManager;
    }

    public FsIndexDescription[] getFsIndexDescriptions() {
        return this.fsIndexDescriptions;
    }

    public void setFsIndexDescriptions(FsIndexDescription[] fsIndexDescriptions) {
        this.fsIndexDescriptions = fsIndexDescriptions;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public TypePriorities getTypePriorities() {
        return this.typePriorities;
    }

    public void setTypePriorities(TypePriorities typePriorities) {
        this.typePriorities = typePriorities;
    }

    public TypeSystemDescription getTypeSystemDescription() {
        return this.typeSystemDescription;
    }

    public void setTypeSystemDescription(TypeSystemDescription typeSystemDescription) {
        this.typeSystemDescription = typeSystemDescription;
    }

    public CasManager getCasManager() {
        if (this.resourceManager != null) {
            return this.resourceManager.getCasManager();
        }
        return null;
    }

    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        ProcessingResourceMetaData md = UIMAFramework.getResourceSpecifierFactory().createProcessingResourceMetaData();
        md.setTypeSystem(this.getTypeSystemDescription());
        md.setTypePriorities(this.getTypePriorities());
        FsIndexCollection indColl = UIMAFramework.getResourceSpecifierFactory().createFsIndexCollection();
        indColl.setFsIndexes(this.getFsIndexDescriptions());
        md.setFsIndexCollection(indColl);
        return md;
    }

    public TypeSystemImpl getTypeSystemImpl() {
        return this.typeSystemImpl;
    }

    public void setTypeSystemImpl(TypeSystemImpl typeSystemImpl) {
        this.typeSystemImpl = typeSystemImpl;
    }
}

