/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.GenericNamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.AggregateMetricDoubleArrayBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleBlockBuilder;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntBlockBuilder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public class AggregateMetricDoubleBlockBuilder
extends AbstractBlockBuilder
implements BlockLoader.AggregateMetricDoubleBuilder {
    private DoubleBlockBuilder minBuilder = null;
    private DoubleBlockBuilder maxBuilder = null;
    private DoubleBlockBuilder sumBuilder = null;
    private IntBlockBuilder countBuilder = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AggregateMetricDoubleBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        try {
            this.minBuilder = new DoubleBlockBuilder(estimatedSize, blockFactory);
            this.maxBuilder = new DoubleBlockBuilder(estimatedSize, blockFactory);
            this.sumBuilder = new DoubleBlockBuilder(estimatedSize, blockFactory);
            this.countBuilder = new IntBlockBuilder(estimatedSize, blockFactory);
            if (this.countBuilder != null) return;
        }
        catch (Throwable throwable) {
            if (this.countBuilder != null) throw throwable;
            Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.minBuilder, this.maxBuilder, this.sumBuilder, this.countBuilder});
            throw throwable;
        }
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.minBuilder, this.maxBuilder, this.sumBuilder, this.countBuilder});
    }

    @Override
    protected int valuesLength() {
        throw new UnsupportedOperationException("Not available on aggregate_metric_double");
    }

    @Override
    protected void growValuesArray(int newSize) {
        throw new UnsupportedOperationException("Not available on aggregate_metric_double");
    }

    @Override
    protected int elementSize() {
        throw new UnsupportedOperationException("Not available on aggregate_metric_double");
    }

    @Override
    public AggregateMetricDoubleBlockBuilder copyFrom(Block b, int beginInclusive, int endExclusive) {
        Block countBlock;
        Block sumBlock;
        Block maxBlock;
        Block minBlock;
        if (b.areAllValuesNull()) {
            minBlock = b;
            maxBlock = b;
            sumBlock = b;
            countBlock = b;
        } else {
            AggregateMetricDoubleBlock block = (AggregateMetricDoubleBlock)b;
            minBlock = block.minBlock();
            maxBlock = block.maxBlock();
            sumBlock = block.sumBlock();
            countBlock = block.countBlock();
        }
        this.minBuilder.copyFrom(minBlock, beginInclusive, endExclusive);
        this.maxBuilder.copyFrom(maxBlock, beginInclusive, endExclusive);
        this.sumBuilder.copyFrom(sumBlock, beginInclusive, endExclusive);
        this.countBuilder.copyFrom(countBlock, beginInclusive, endExclusive);
        return this;
    }

    @Override
    public AggregateMetricDoubleBlockBuilder appendNull() {
        this.minBuilder.appendNull();
        this.maxBuilder.appendNull();
        this.sumBuilder.appendNull();
        this.countBuilder.appendNull();
        return this;
    }

    @Override
    public AggregateMetricDoubleBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.minBuilder.mvOrdering(mvOrdering);
        this.maxBuilder.mvOrdering(mvOrdering);
        this.sumBuilder.mvOrdering(mvOrdering);
        this.countBuilder.mvOrdering(mvOrdering);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateMetricDoubleBlock build() {
        AggregateMetricDoubleArrayBlock aggregateMetricDoubleArrayBlock;
        block3: {
            DoubleBlock minBlock = null;
            DoubleBlock maxBlock = null;
            DoubleBlock sumBlock = null;
            IntBlock countBlock = null;
            boolean success = false;
            try {
                this.finish();
                minBlock = this.minBuilder.build();
                maxBlock = this.maxBuilder.build();
                sumBlock = this.sumBuilder.build();
                countBlock = this.countBuilder.build();
                AggregateMetricDoubleArrayBlock block = new AggregateMetricDoubleArrayBlock(minBlock, maxBlock, sumBlock, countBlock);
                success = true;
                aggregateMetricDoubleArrayBlock = block;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock});
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock});
        }
        return aggregateMetricDoubleArrayBlock;
    }

    @Override
    protected void extraClose() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.minBuilder, this.maxBuilder, this.sumBuilder, this.countBuilder});
    }

    public BlockLoader.DoubleBuilder min() {
        return this.minBuilder;
    }

    public BlockLoader.DoubleBuilder max() {
        return this.maxBuilder;
    }

    public BlockLoader.DoubleBuilder sum() {
        return this.sumBuilder;
    }

    public BlockLoader.IntBuilder count() {
        return this.countBuilder;
    }

    public record AggregateMetricDoubleLiteral(Double min, Double max, Double sum, Integer count) implements GenericNamedWriteable
    {
        private static final TransportVersion ESQL_AGGREGATE_METRIC_DOUBLE_LITERAL = TransportVersion.fromName((String)"esql_aggregate_metric_double_literal");
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(GenericNamedWriteable.class, "AggregateMetricDoubleLiteral", AggregateMetricDoubleLiteral::new);

        public AggregateMetricDoubleLiteral {
            min = min == null || min.isNaN() ? null : min;
            max = max == null || max.isNaN() ? null : max;
            sum = sum == null || sum.isNaN() ? null : sum;
        }

        public AggregateMetricDoubleLiteral(StreamInput input) throws IOException {
            this(input.readOptionalDouble(), input.readOptionalDouble(), input.readOptionalDouble(), input.readOptionalInt());
        }

        public String getWriteableName() {
            return "AggregateMetricDoubleLiteral";
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalDouble(this.min);
            out.writeOptionalDouble(this.max);
            out.writeOptionalDouble(this.sum);
            out.writeOptionalInt(this.count);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return ESQL_AGGREGATE_METRIC_DOUBLE_LITERAL;
        }
    }

    public static enum Metric {
        MIN(0, "min"),
        MAX(1, "max"),
        SUM(2, "sum"),
        COUNT(3, "value_count");

        private final int index;
        private final String label;

        private Metric(int index, String label) {
            this.index = index;
            this.label = label;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

