/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;

public class PyTorchPassThroughResults
extends NlpInferenceResults {
    public static final String NAME = "pass_through_result";
    private final double[][] inference;
    private final String resultsField;

    public PyTorchPassThroughResults(String resultsField, double[][] inference, boolean isTruncated) {
        super(isTruncated);
        this.inference = inference;
        this.resultsField = resultsField;
    }

    public PyTorchPassThroughResults(StreamInput in) throws IOException {
        super(in);
        this.inference = (double[][])in.readArray(StreamInput::readDoubleArray, x$0 -> new double[x$0][]);
        this.resultsField = in.readString();
    }

    public double[][] getInference() {
        return this.inference;
    }

    @Override
    void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, (Object)this.inference);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeArray(StreamOutput::writeDoubleArray, (Object[])this.inference);
        out.writeString(this.resultsField);
    }

    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.inference);
    }

    @Override
    public Map<String, Object> asMap(String outputField) {
        Map<String, Object> map = super.asMap(outputField);
        map.put(outputField, this.inference);
        return map;
    }

    public Object predictedValue() {
        throw new UnsupportedOperationException("[pass_through_result] does not support a single predicted value");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyTorchPassThroughResults that = (PyTorchPassThroughResults)o;
        return Arrays.deepEquals((Object[])this.inference, (Object[])that.inference) && Objects.equals(this.resultsField, that.resultsField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, Arrays.deepHashCode((Object[])this.inference));
    }
}

