/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteComposableIndexTemplateAction;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.client.internal.AdminClient;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ClusterAdminClient;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.node.MockNode;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.MockScriptService;
import org.elasticsearch.search.ConcurrentSearchTestPlugin;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.MockHttpTransport;
import org.elasticsearch.test.NodeRoles;
import org.elasticsearch.test.TestSearchContext;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class ESSingleNodeTestCase
extends ESTestCase {
    private static Node NODE = null;

    protected void startNode(long seed) throws Exception {
        assert (NODE == null);
        NODE = (Node)RandomizedContext.current().runWithPrivateRandomness(seed, this::newNode);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)this.clusterAdmin().prepareHealth(TEST_REQUEST_TIMEOUT, new String[0]).setWaitForGreenStatus().get();
        ESSingleNodeTestCase.assertFalse((boolean)clusterHealthResponse.isTimedOut());
        this.indicesAdmin().preparePutTemplate("one_shard_index_template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(ESSingleNodeTestCase.indexSettings(1, 0)).get();
        this.indicesAdmin().preparePutTemplate("random-soft-deletes-template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(Settings.builder().put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), ESSingleNodeTestCase.between(0, 1000))).get();
    }

    private static void stopNode() throws IOException, InterruptedException {
        Node node = NODE;
        NODE = null;
        IOUtils.close((Closeable)node);
        if (node != null && !node.awaitClose(10L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Node couldn't close within 10 seconds.");
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        long seed = ESSingleNodeTestCase.random().nextLong();
        if (NODE == null) {
            this.startNode(seed);
        }
    }

    public void tearDown() throws Exception {
        block4: {
            this.logger.trace("[{}#{}]: cleaning up after test", (Object)ESSingleNodeTestCase.getTestClass().getSimpleName(), (Object)this.getTestName());
            this.awaitIndexShardCloseAsyncTasks();
            this.ensureNoInitializingShards();
            this.ensureAllFreeContextActionsAreConsumed();
            ESSingleNodeTestCase.ensureAllContextsReleased(this.getInstanceFromNode(SearchService.class));
            super.tearDown();
            DeleteDataStreamAction.Request deleteDataStreamsRequest = new DeleteDataStreamAction.Request(TEST_REQUEST_TIMEOUT, new String[]{"*"});
            deleteDataStreamsRequest.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN);
            try {
                ElasticsearchAssertions.assertAcked(this.client().execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)deleteDataStreamsRequest));
            }
            catch (IllegalStateException e) {
                if (e.getMessage().startsWith("failed to find action")) break block4;
                throw e;
            }
        }
        TransportDeleteComposableIndexTemplateAction.Request deleteComposableIndexTemplateRequest = new TransportDeleteComposableIndexTemplateAction.Request(new String[]{"*"});
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)this.client().execute(TransportDeleteComposableIndexTemplateAction.TYPE, (ActionRequest)deleteComposableIndexTemplateRequest).actionGet());
        TransportDeleteComponentTemplateAction.Request deleteComponentTemplateRequest = new TransportDeleteComponentTemplateAction.Request(new String[]{"*"});
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)this.client().execute(TransportDeleteComponentTemplateAction.TYPE, (ActionRequest)deleteComponentTemplateRequest).actionGet());
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)this.indicesAdmin().prepareDelete(new String[]{"*"}).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN).get());
        Metadata metadata = ((ClusterStateResponse)this.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).get()).getState().getMetadata();
        ESSingleNodeTestCase.assertThat("test leaves persistent cluster metadata behind: " + String.valueOf(metadata.persistentSettings().keySet()), metadata.persistentSettings().size(), Matchers.equalTo((Object)0));
        ESSingleNodeTestCase.assertThat("test leaves transient cluster metadata behind: " + String.valueOf(metadata.transientSettings().keySet()), metadata.transientSettings().size(), Matchers.equalTo((Object)0));
        GetIndexResponse indices = (GetIndexResponse)((GetIndexRequestBuilder)((GetIndexRequestBuilder)this.indicesAdmin().prepareGetIndex().setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN)).addIndices(new String[]{"*"})).get();
        ESSingleNodeTestCase.assertThat("test leaves indices that were not deleted: " + Strings.arrayToCommaDelimitedString((Object[])indices.indices()), indices.indices(), Matchers.equalTo((Object)Strings.EMPTY_ARRAY));
        if (this.resetNodeAfterTest()) {
            assert (NODE != null);
            ESSingleNodeTestCase.stopNode();
            this.startNode(ESSingleNodeTestCase.random().nextLong());
        }
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        ESSingleNodeTestCase.stopNode();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        ESSingleNodeTestCase.stopNode();
        ESIntegTestCase.awaitGlobalNettyThreadsFinish();
    }

    protected boolean resetNodeAfterTest() {
        return false;
    }

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.emptyList();
    }

    @SafeVarargs
    protected final Collection<Class<? extends Plugin>> pluginList(Class<? extends Plugin> ... plugins) {
        return Arrays.asList(plugins);
    }

    protected Settings nodeSettings() {
        return Settings.EMPTY;
    }

    protected boolean addMockHttpTransport() {
        return true;
    }

    @Override
    protected List<String> filteredWarnings() {
        return Stream.concat(super.filteredWarnings().stream(), Stream.of("[index.data_path] setting was deprecated in Elasticsearch and will be removed in a future release.")).collect(Collectors.toList());
    }

    private Node newNode() {
        Path tempDir = ESSingleNodeTestCase.createTempDir();
        String nodeName = this.nodeSettings().get(Node.NODE_NAME_SETTING.getKey(), "node_s_0");
        Settings.Builder settingBuilder = Settings.builder().put(ClusterName.CLUSTER_NAME_SETTING.getKey(), InternalTestCluster.clusterName("single-node-cluster", ESSingleNodeTestCase.random().nextLong())).put(DestructiveOperations.REQUIRES_NAME_SETTING.getKey(), false).put(Environment.PATH_HOME_SETTING.getKey(), tempDir).put(Environment.PATH_REPO_SETTING.getKey(), tempDir.resolve("repo")).put(Environment.PATH_SHARED_DATA_SETTING.getKey(), ESSingleNodeTestCase.createTempDir().getParent()).put(Node.NODE_NAME_SETTING.getKey(), nodeName).put(EsExecutors.NODE_PROCESSORS_SETTING.getKey(), 1).put("transport.type", ESSingleNodeTestCase.getTestTransportType()).put(TransportSettings.PORT.getKey(), ESTestCase.getPortRange()).put(NodeRoles.dataNode()).put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), ESSingleNodeTestCase.random().nextLong()).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), "1b").put(HierarchyCircuitBreakerService.USE_REAL_MEMORY_USAGE_SETTING.getKey(), false).putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]).putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), new String[]{nodeName}).put(this.nodeSettings());
        boolean enableConcurrentSearch = this.enableConcurrentSearch();
        if (enableConcurrentSearch) {
            settingBuilder.put(SearchService.MINIMUM_DOCS_PER_SLICE.getKey(), 1);
        } else {
            settingBuilder.put(SearchService.QUERY_PHASE_PARALLEL_COLLECTION_ENABLED.getKey(), false);
        }
        Settings settings = settingBuilder.build();
        ArrayList<Class<? extends Plugin>> plugins = new ArrayList<Class<? extends Plugin>>(this.getPlugins());
        if (!plugins.contains(ESSingleNodeTestCase.getTestTransportPlugin())) {
            plugins.add(ESSingleNodeTestCase.getTestTransportPlugin());
        }
        if (this.addMockHttpTransport()) {
            plugins.add(MockHttpTransport.TestPlugin.class);
        }
        if (enableConcurrentSearch) {
            plugins.add(ConcurrentSearchTestPlugin.class);
        }
        plugins.add(MockScriptService.TestPlugin.class);
        MockNode node = new MockNode(settings, plugins, this.forbidPrivateIndexSettings(), TEST_ENTITLEMENTS.addEntitledNodePaths(settings, null));
        try {
            node.start();
        }
        catch (NodeValidationException e) {
            throw new RuntimeException(e);
        }
        return node;
    }

    public Client client() {
        return this.wrapClient(NODE.client());
    }

    public <T extends ActionResponse> T safeExecute(ActionType<T> action, ActionRequest request) {
        return ESSingleNodeTestCase.safeExecute((ElasticsearchClient)this.client(), action, request);
    }

    protected AdminClient admin() {
        return this.client().admin();
    }

    protected IndicesAdminClient indicesAdmin() {
        return this.admin().indices();
    }

    protected ClusterAdminClient clusterAdmin() {
        return this.admin().cluster();
    }

    public Client wrapClient(Client client) {
        return client;
    }

    protected Node node() {
        return NODE;
    }

    protected <T> T getInstanceFromNode(Class<T> clazz) {
        return (T)NODE.injector().getInstance(clazz);
    }

    protected IndexService createIndex(String index) {
        return this.createIndex(index, Settings.EMPTY);
    }

    protected IndexService createIndex(String index, Settings settings) {
        return this.createIndex(index, settings, null);
    }

    protected IndexService createIndex(String index, Settings settings, XContentBuilder mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.indicesAdmin().prepareCreate(index).setSettings(settings);
        if (mappings != null) {
            createIndexRequestBuilder.setMapping(mappings);
        }
        return this.createIndex(index, createIndexRequestBuilder);
    }

    protected IndexService createIndex(String index, Settings settings, String type, String ... mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.indicesAdmin().prepareCreate(index).setSettings(settings);
        if (type != null) {
            createIndexRequestBuilder.setMapping(mappings);
        }
        return this.createIndex(index, createIndexRequestBuilder);
    }

    protected IndexService createIndex(String index, CreateIndexRequestBuilder createIndexRequestBuilder) {
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)createIndexRequestBuilder.get());
        ClusterHealthResponse health = (ClusterHealthResponse)this.clusterAdmin().health(new ClusterHealthRequest(TEST_REQUEST_TIMEOUT, new String[]{index}).waitForYellowStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        ESSingleNodeTestCase.assertThat(health.getStatus(), Matchers.lessThanOrEqualTo((Comparable)ClusterHealthStatus.YELLOW));
        ESSingleNodeTestCase.assertThat("Cluster must be a single node cluster", health.getNumberOfDataNodes(), Matchers.equalTo((Object)1));
        IndicesService instanceFromNode = this.getInstanceFromNode(IndicesService.class);
        return instanceFromNode.indexServiceSafe(this.resolveIndex(index));
    }

    public Index resolveIndex(String index) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)this.indicesAdmin().prepareGetIndex().setIndices(new String[]{index})).get();
        ESSingleNodeTestCase.assertTrue((String)("index " + index + " not found"), (boolean)getIndexResponse.getSettings().containsKey(index));
        String uuid = ((Settings)getIndexResponse.getSettings().get(index)).get("index.uuid");
        return new Index(index, uuid);
    }

    protected IndexRequestBuilder prepareIndex(String index) {
        return this.client().prepareIndex(index);
    }

    protected SearchContext createSearchContext(IndexService indexService) {
        return new TestSearchContext(indexService);
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        return this.ensureGreen(TimeValue.timeValueSeconds((long)30L), indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.clusterAdmin().health(((ClusterHealthRequest)new ClusterHealthRequest(TEST_REQUEST_TIMEOUT, indices).masterNodeTimeout(timeout)).timeout(timeout).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        if (actionGet.isTimedOut()) {
            this.logger.info("ensureGreen timed out, cluster state:\n{}\n{}", (Object)((ClusterStateResponse)this.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).get()).getState(), (Object)ESIntegTestCase.getClusterPendingTasks(this.client()));
            ESSingleNodeTestCase.assertThat("timed out waiting for green state", actionGet.isTimedOut(), Matchers.equalTo((Object)false));
        }
        ESSingleNodeTestCase.assertThat(actionGet.getStatus(), Matchers.equalTo((Object)ClusterHealthStatus.GREEN));
        this.logger.debug("indices {} are green", (Object)(indices.length == 0 ? "[_all]" : indices));
        return actionGet.getStatus();
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.getInstanceFromNode(NamedXContentRegistry.class);
    }

    protected boolean forbidPrivateIndexSettings() {
        return true;
    }

    protected void ensureNoInitializingShards() {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.clusterAdmin().health(new ClusterHealthRequest(TEST_REQUEST_TIMEOUT, new String[]{"_all"}).waitForNoInitializingShards(true)).actionGet();
        ESSingleNodeTestCase.assertFalse((String)"timed out waiting for shards to initialize", (boolean)actionGet.isTimedOut());
    }

    protected void ensureAllFreeContextActionsAreConsumed() throws Exception {
        this.logger.info("--> waiting for all free_context tasks to complete within a reasonable time");
        ESSingleNodeTestCase.safeGet(((ListTasksRequestBuilder)this.clusterAdmin().prepareListTasks(new String[0]).setActions(new String[]{"indices:data/read/search[free_context/scroll]*"})).setWaitForCompletion(true).execute());
    }

    protected boolean enableConcurrentSearch() {
        return true;
    }

    protected void awaitIndexShardCloseAsyncTasks() {
        CountDownLatch latch = new CountDownLatch(1);
        this.getInstanceFromNode(IndicesClusterStateService.class).onClusterStateShardsClosed(latch::countDown);
        ESSingleNodeTestCase.safeAwait(latch);
    }
}

