/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.global.Global;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.AbstractGeoTestCase;
import org.elasticsearch.search.aggregations.metrics.SpatialBounds;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matchers;

@ESIntegTestCase.SuiteScopeTestCase
public abstract class SpatialBoundsAggregationTestBase<T extends SpatialPoint>
extends AbstractGeoTestCase {
    protected abstract String aggName();

    protected abstract ValuesSourceAggregationBuilder<?> boundsAgg(String var1, String var2);

    protected abstract void assertBoundsLimits(SpatialBounds<T> var1);

    public void testSingleValuedField() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds.getName(), Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getY(), Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getX(), Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getY(), Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getX(), Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testSingleValuedField_getProperty() {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AggregationBuilder)AggregationBuilders.global((String)"global").subAggregation(this.boundsAgg(this.aggName(), "spatial_value"))), response -> {
            Global global = (Global)response.getAggregations().get("global");
            SpatialBoundsAggregationTestBase.assertThat(global, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(global.getName(), Matchers.equalTo((Object)"global"));
            SpatialBoundsAggregationTestBase.assertThat(global.getDocCount(), Matchers.equalTo((Object)numDocs));
            SpatialBoundsAggregationTestBase.assertThat(global.getAggregations(), Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(global.getAggregations().asList().size(), Matchers.equalTo((Object)1));
            SpatialBounds geobounds = (SpatialBounds)global.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat(geobounds, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(geobounds.getName(), Matchers.equalTo((Object)this.aggName()));
            SpatialBoundsAggregationTestBase.assertThat((SpatialBounds)((InternalAggregation)global).getProperty(this.aggName()), Matchers.sameInstance((Object)geobounds));
            SpatialPoint topLeft = geobounds.topLeft();
            SpatialPoint bottomRight = geobounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getY(), Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getX(), Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getY(), Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getX(), Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(Double.valueOf((Double)((InternalAggregation)global).getProperty(this.aggName() + ".top")), Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(Double.valueOf((Double)((InternalAggregation)global).getProperty(this.aggName() + ".left")), Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(Double.valueOf((Double)((InternalAggregation)global).getProperty(this.aggName() + ".bottom")), Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(Double.valueOf((Double)((InternalAggregation)global).getProperty(this.aggName() + ".right")), Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testMultiValuedField() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_values")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds.getName(), Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getY(), Matchers.closeTo((double)multiTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getX(), Matchers.closeTo((double)multiTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getY(), Matchers.closeTo((double)multiBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getX(), Matchers.closeTo((double)multiBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testUnmapped() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx_unmapped"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds.getName(), Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat(topLeft, Matchers.equalTo(null));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight, Matchers.equalTo(null));
        });
    }

    public void testPartiallyUnmapped() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx", "idx_unmapped"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds.getName(), Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getY(), Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getX(), Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getY(), Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getX(), Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testEmptyAggregation() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"empty_idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBoundsAggregationTestBase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)0L));
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds.getName(), Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat(topLeft, Matchers.equalTo(null));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight, Matchers.equalTo(null));
        });
    }

    public void testSingleValuedFieldAsSubAggToHighCardTermsAgg() {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"high_card_idx"}).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"terms").field("l_values")).subAggregation(this.boundsAgg(this.aggName(), "spatial_value"))), response -> {
            Terms terms = (Terms)response.getAggregations().get("terms");
            SpatialBoundsAggregationTestBase.assertThat(terms, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(terms.getName(), Matchers.equalTo((Object)"terms"));
            List buckets = terms.getBuckets();
            SpatialBoundsAggregationTestBase.assertThat(buckets.size(), Matchers.equalTo((Object)10));
            for (int i = 0; i < 10; ++i) {
                Terms.Bucket bucket = (Terms.Bucket)buckets.get(i);
                SpatialBoundsAggregationTestBase.assertThat(bucket, Matchers.notNullValue());
                SpatialBoundsAggregationTestBase.assertThat("InternalBucket " + String.valueOf(bucket.getKey()) + " has wrong number of documents", bucket.getDocCount(), Matchers.equalTo((Object)1L));
                SpatialBounds geoBounds = (SpatialBounds)bucket.getAggregations().get(this.aggName());
                SpatialBoundsAggregationTestBase.assertThat(geoBounds, Matchers.notNullValue());
                SpatialBoundsAggregationTestBase.assertThat(geoBounds.getName(), Matchers.equalTo((Object)this.aggName()));
                this.assertBoundsLimits(geoBounds);
            }
        });
    }

    public void testSingleValuedFieldWithZeroLon() {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx_zero"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds, Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat(geoBounds.getName(), Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getY(), Matchers.closeTo((double)1.0, (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(topLeft.getX(), Matchers.closeTo((double)0.0, (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getY(), Matchers.closeTo((double)1.0, (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat(bottomRight.getX(), Matchers.closeTo((double)0.0, (double)1.0E-5));
        });
    }
}

