/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.MockLog;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportService;

public final class ErrorTraceHelper
extends Enum<ErrorTraceHelper> {
    private static final /* synthetic */ ErrorTraceHelper[] $VALUES;

    public static ErrorTraceHelper[] values() {
        return (ErrorTraceHelper[])$VALUES.clone();
    }

    public static ErrorTraceHelper valueOf(String name) {
        return Enum.valueOf(ErrorTraceHelper.class, name);
    }

    public static BooleanSupplier setupErrorTraceListener(InternalTestCluster internalCluster) {
        final AtomicBoolean transportMessageHasStackTrace = new AtomicBoolean(false);
        internalCluster.getDataNodeInstances(TransportService.class).forEach(ts -> ESTestCase.asInstanceOf(MockTransportService.class, ts).addMessageListener(new TransportMessageListener(){

            public void onResponseSent(long requestId, String action, Exception error) {
                super.onResponseSent(requestId, action, error);
                if (action.startsWith("indices:data/read/search")) {
                    Optional throwable = ExceptionsHelper.unwrapCausesAndSuppressed((Throwable)error, t -> t.getStackTrace().length > 0);
                    transportMessageHasStackTrace.set(throwable.isPresent());
                }
            }
        }));
        return transportMessageHasStackTrace::get;
    }

    public static void addSeenLoggingExpectations(int numShards, MockLog mockLog, String errorTriggeringIndex) {
        String nodesDisjunction = Strings.format((String)"(%s)", (Object[])new Object[]{Arrays.stream(ESIntegTestCase.internalCluster().getNodeNames()).map(ESIntegTestCase::getNodeId).collect(Collectors.joining("|"))});
        for (int shard = 0; shard < numShards; ++shard) {
            mockLog.addExpectation(new MockLog.PatternAndExceptionSeenEventExpectation(Strings.format((String)"\"[%s][%s][%d]: failed to execute search request for task [\\d+]\" and an exception logged", (Object[])new Object[]{nodesDisjunction, errorTriggeringIndex, shard}), SearchService.class.getCanonicalName(), Level.DEBUG, Strings.format((String)"\\[%s\\]\\[%s\\]\\[%d\\]: failed to execute search request for task \\[\\d+\\]", (Object[])new Object[]{nodesDisjunction, errorTriggeringIndex, shard}), QueryShardException.class, "failed to create query: For input string: \"foo\""));
        }
    }

    private static /* synthetic */ ErrorTraceHelper[] $values() {
        return new ErrorTraceHelper[0];
    }

    static {
        $VALUES = ErrorTraceHelper.$values();
    }
}

