/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RelocationFailureInfo;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.test.ESTestCase;
import org.junit.Assert;

public class TestShardRouting {
    private static final Logger logger = LogManager.getLogger(TestShardRouting.class);

    public static Builder shardRoutingBuilder(String index, int shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.shardRoutingBuilder(new ShardId(index, "_na_", shardId), currentNodeId, primary, state);
    }

    public static Builder shardRoutingBuilder(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        return new Builder(shardId, currentNodeId, primary, state);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, primary, state);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource) {
        return TestShardRouting.newShardRouting(shardId, currentNodeId, primary, state, recoverySource, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        Assert.assertNotEquals((Object)ShardRoutingState.RELOCATING, (Object)state);
        return new ShardRouting(shardId, currentNodeId, null, primary, state, TestShardRouting.buildRecoverySource(primary, state), TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildRelocationFailureInfo(state), TestShardRouting.buildAllocationId(state), -1L, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource, ShardRouting.Role role) {
        Assert.assertNotEquals((Object)ShardRoutingState.RELOCATING, (Object)state);
        return new ShardRouting(shardId, currentNodeId, null, primary, state, recoverySource, TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildRelocationFailureInfo(state), TestShardRouting.buildAllocationId(state), -1L, role);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, TestShardRouting.buildRecoverySource(primary, state), TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildRelocationFailureInfo(state), TestShardRouting.buildAllocationId(state), -1L, ShardRouting.Role.DEFAULT);
    }

    public static RecoverySource buildRecoverySource(boolean primary, ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED, ShardRoutingState.INITIALIZING -> {
                if (primary) {
                    yield ESTestCase.randomFrom(RecoverySource.EmptyStoreRecoverySource.INSTANCE, RecoverySource.ExistingStoreRecoverySource.INSTANCE);
                }
                yield RecoverySource.PeerRecoverySource.INSTANCE;
            }
            case ShardRoutingState.STARTED, ShardRoutingState.RELOCATING -> null;
        };
    }

    public static AllocationId buildAllocationId(ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED -> null;
            case ShardRoutingState.INITIALIZING, ShardRoutingState.STARTED -> AllocationId.newInitializing((String)ESTestCase.randomUUID());
            case ShardRoutingState.RELOCATING -> AllocationId.newRelocation((AllocationId)AllocationId.newInitializing((String)ESTestCase.randomUUID()));
        };
    }

    public static UnassignedInfo buildUnassignedInfo(ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED, ShardRoutingState.INITIALIZING -> TestShardRouting.buildUnassignedInfo("auto generated for test");
            case ShardRoutingState.STARTED, ShardRoutingState.RELOCATING -> null;
        };
    }

    public static RelocationFailureInfo buildRelocationFailureInfo(ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED, ShardRoutingState.INITIALIZING, ShardRoutingState.STARTED -> RelocationFailureInfo.NO_FAILURES;
            case ShardRoutingState.RELOCATING -> ESTestCase.randomBoolean() ? RelocationFailureInfo.NO_FAILURES : new RelocationFailureInfo(ESTestCase.randomIntBetween(1, 10));
        };
    }

    public static UnassignedInfo buildUnassignedInfo(String message) {
        UnassignedInfo.Reason reason = ESTestCase.randomFrom(UnassignedInfo.Reason.values());
        String lastAllocatedNodeId = null;
        boolean delayed = false;
        if (reason == UnassignedInfo.Reason.NODE_LEFT || reason == UnassignedInfo.Reason.NODE_RESTARTING) {
            if (ESTestCase.randomBoolean()) {
                delayed = true;
            }
            lastAllocatedNodeId = ESTestCase.randomIdentifier();
        }
        int failedAllocations = reason == UnassignedInfo.Reason.ALLOCATION_FAILED ? 1 : 0;
        long unassignedTimeMillis = ESTestCase.randomNonNegativeLong();
        long unassignedTimeNanos = ESTestCase.randomLongBetween(0L, 1000000000L);
        TestShardRouting.ensureInPast(unassignedTimeNanos);
        return new UnassignedInfo(reason, message, null, failedAllocations, unassignedTimeNanos, unassignedTimeMillis, delayed, UnassignedInfo.AllocationStatus.NO_ATTEMPT, Set.of(), lastAllocatedNodeId);
    }

    private static void ensureInPast(long nanoTime) {
        while (System.nanoTime() < nanoTime) {
            logger.info("Waiting to ensure selected nano-time [{}] is in past", (Object)nanoTime);
            ESTestCase.safeSleep(1000L);
        }
    }

    public static RecoverySource buildRecoverySource() {
        return ESTestCase.randomFrom(RecoverySource.EmptyStoreRecoverySource.INSTANCE, RecoverySource.ExistingStoreRecoverySource.INSTANCE, RecoverySource.PeerRecoverySource.INSTANCE, RecoverySource.LocalShardsRecoverySource.INSTANCE, new RecoverySource.SnapshotRecoverySource(ESTestCase.randomUUID(), new Snapshot("repo", new SnapshotId(ESTestCase.randomIdentifier(), ESTestCase.randomUUID())), IndexVersion.current(), new IndexId("some_index", ESTestCase.randomUUID())));
    }

    public static class Builder {
        private final ShardId shardId;
        private String currentNodeId;
        private String relocatingNodeId;
        private boolean primary;
        private ShardRoutingState state;
        private RecoverySource recoverySource;
        private UnassignedInfo unassignedInfo;
        private RelocationFailureInfo relocationFailureInfo;
        private AllocationId allocationId;
        private Long expectedShardSize;
        private ShardRouting.Role role;

        public Builder(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
            this.shardId = shardId;
            this.currentNodeId = currentNodeId;
            this.primary = primary;
            this.state = state;
        }

        public Builder withRelocatingNodeId(String relocatingNodeId) {
            this.relocatingNodeId = relocatingNodeId;
            return this;
        }

        public Builder withRecoverySource(RecoverySource recoverySource) {
            this.recoverySource = recoverySource;
            return this;
        }

        public Builder withUnassignedInfo(UnassignedInfo unassignedInfo) {
            this.unassignedInfo = unassignedInfo;
            return this;
        }

        public Builder withRelocationFailureInfo(RelocationFailureInfo relocationFailureInfo) {
            this.relocationFailureInfo = relocationFailureInfo;
            return this;
        }

        public Builder withAllocationId(AllocationId allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public Builder withExpectedShardSize(Long expectedShardSize) {
            this.expectedShardSize = expectedShardSize;
            return this;
        }

        public Builder withRole(ShardRouting.Role role) {
            this.role = role;
            return this;
        }

        public ShardRouting build() {
            return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, this.primary, this.state, this.recoverySource != null ? this.recoverySource : TestShardRouting.buildRecoverySource(this.primary, this.state), this.unassignedInfo != null ? this.unassignedInfo : TestShardRouting.buildUnassignedInfo(this.state), this.relocationFailureInfo != null ? this.relocationFailureInfo : TestShardRouting.buildRelocationFailureInfo(this.state), this.allocationId != null ? this.allocationId : TestShardRouting.buildAllocationId(this.state), this.expectedShardSize != null ? this.expectedShardSize : -1L, this.role != null ? this.role : ShardRouting.Role.DEFAULT);
        }
    }
}

