/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.anthropic.action.AnthropicActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public abstract class AnthropicModel
extends Model {
    private final AnthropicRateLimitServiceSettings rateLimitServiceSettings;
    private final SecureString apiKey;
    private final URI uri;

    public AnthropicModel(ModelConfigurations configurations, ModelSecrets secrets, AnthropicRateLimitServiceSettings rateLimitServiceSettings, CheckedSupplier<URI, URISyntaxException> uriSupplier, @Nullable ApiKeySecrets apiKeySecrets) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
        try {
            this.uri = (URI)uriSupplier.get();
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException(Strings.format((String)"Failed to construct %s URL", (Object[])new Object[]{configurations.getService()}), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }

    protected AnthropicModel(AnthropicModel model, TaskSettings taskSettings) {
        super((Model)model, taskSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
        this.uri = model.getUri();
    }

    protected AnthropicModel(AnthropicModel model, ServiceSettings serviceSettings) {
        super((Model)model, serviceSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
        this.uri = model.getUri();
    }

    public URI getUri() {
        return this.uri;
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public AnthropicRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public abstract ExecutableAction accept(AnthropicActionVisitor var1, Map<String, Object> var2);
}

