/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.request;

import java.net.URI;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockBaseClient;

public abstract class AmazonBedrockRequest
implements Request {
    protected final AmazonBedrockModel amazonBedrockModel;
    protected final String inferenceId;
    protected final TimeValue timeout;

    protected AmazonBedrockRequest(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        this.amazonBedrockModel = model;
        this.inferenceId = model.getInferenceEntityId();
        this.timeout = timeout;
    }

    protected abstract void executeRequest(AmazonBedrockBaseClient var1);

    public AmazonBedrockModel model() {
        return this.amazonBedrockModel;
    }

    @Override
    public final HttpRequest createHttpRequest() {
        throw new UnsupportedOperationException("Amazon Bedrock does not use Http Requests");
    }

    @Override
    public final URI getURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return new boolean[0];
    }

    @Override
    public String getInferenceEntityId() {
        return this.amazonBedrockModel.getInferenceEntityId();
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public abstract TaskType taskType();
}

