/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;

public class RestPutWatchAction
extends BaseRestHandler
implements RestRequestFilter {
    private static final Set<String> FILTERED_FIELDS = Set.of("input.http.request.auth.basic.password", "input.chain.inputs.*.http.request.auth.basic.password", "actions.*.email.attachments.*.reporting.auth.basic.password", "actions.*.webhook.auth.basic.password");

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_watcher/watch/{id}").replaces(RestRequest.Method.POST, "/_xpack/watcher/watch/{id}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_watcher/watch/{id}").replaces(RestRequest.Method.PUT, "/_xpack/watcher/watch/{id}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "watcher_put_watch";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) {
        ReleasableBytesReference content = request.content();
        PutWatchRequest putWatchRequest = new PutWatchRequest(request.param("id"), (BytesReference)content, request.getXContentType());
        putWatchRequest.setVersion(request.paramAsLong("version", -3L));
        putWatchRequest.setIfSeqNo(request.paramAsLong("if_seq_no", putWatchRequest.getIfSeqNo()));
        putWatchRequest.setIfPrimaryTerm(request.paramAsLong("if_primary_term", putWatchRequest.getIfPrimaryTerm()));
        putWatchRequest.setActive(request.paramAsBoolean("active", putWatchRequest.isActive()));
        return channel -> client.execute((ActionType)PutWatchAction.INSTANCE, (ActionRequest)putWatchRequest, ActionListener.withRef((ActionListener)new RestBuilderListener<PutWatchResponse>(channel){

            public RestResponse buildResponse(PutWatchResponse response, XContentBuilder builder) throws Exception {
                response.toXContent(builder, (ToXContent.Params)request);
                RestStatus status = response.isCreated() ? RestStatus.CREATED : RestStatus.OK;
                return new RestResponse(status, builder);
            }
        }, (RefCounted)content));
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

