/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.AbstractContinuous;

public class Uniform
extends AbstractContinuous {
    private final double myLower;
    private final double myRange;

    public static Uniform of(double lower, double range) {
        return new Uniform(lower, range);
    }

    public static int randomInteger(int limit) {
        return (int)PrimitiveMath.FLOOR.invoke((double)limit * Math.random());
    }

    public static int randomInteger(int lower, int higher) {
        return lower + Uniform.randomInteger(higher - lower);
    }

    public static long randomInteger(long limit) {
        return (long)PrimitiveMath.FLOOR.invoke((double)limit * Math.random());
    }

    public static Uniform standard() {
        return new Uniform();
    }

    public Uniform() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public Uniform(double lower, double range) {
        if (range <= PrimitiveMath.ZERO) {
            throw new IllegalArgumentException("The range must be larger than 0.0!");
        }
        this.myLower = lower;
        this.myRange = range;
    }

    @Override
    public double getDensity(double value) {
        double retVal = PrimitiveMath.ZERO;
        if (this.myLower <= value && value <= this.myLower + this.myRange) {
            retVal = PrimitiveMath.ONE / this.myRange;
        }
        return retVal;
    }

    @Override
    public double getDistribution(double value) {
        double retVal = PrimitiveMath.ZERO;
        if (value <= this.myLower + this.myRange && this.myLower <= value) {
            retVal = (value - this.myLower) / this.myRange;
        } else if (this.myLower <= value) {
            retVal = PrimitiveMath.ONE;
        }
        return retVal;
    }

    @Override
    public double getExpected() {
        return this.myLower + this.myRange / PrimitiveMath.TWO;
    }

    @Override
    public double getQuantile(double probability) {
        this.checkProbabilty(probability);
        return this.myLower + probability * this.myRange;
    }

    @Override
    public double getVariance() {
        return this.myRange * this.myRange / PrimitiveMath.TWELVE;
    }

    @Override
    protected double generate() {
        return this.myLower + this.myRange * this.random().nextDouble();
    }
}

