/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.CopyingXContentParser;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSourceType;
import org.elasticsearch.xpack.aggregatemetric.fielddata.IndexAggregateMetricDoubleFieldData;
import org.elasticsearch.xpack.aggregatemetric.fielddata.LeafAggregateMetricDoubleFieldData;

public class AggregateMetricDoubleFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(AggregateMetricDoubleFieldMapper.class);
    public static final String CONTENT_TYPE = "aggregate_metric_double";
    public static final String SUBFIELD_SEPARATOR = ".";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings()), c.indexVersionCreated(), c.getIndexSettings().getMode(), c.getIndexSettings().sourceKeepMode()), AggregateMetricDoubleFieldMapper.notInMultiFields((String)"aggregate_metric_double"));
    private final EnumMap<Metric, NumberFieldMapper> metricFieldMappers;
    private final boolean ignoreMalformed;
    private final boolean ignoreMalformedByDefault;
    private final IndexVersion indexCreatedVersion;
    private final EnumSet<Metric> metrics;
    protected Metric defaultMetric;
    private final TimeSeriesParams.MetricType metricType;
    private final IndexMode indexMode;
    private final Mapper.SourceKeepMode indexSourceKeepMode;

    private static AggregateMetricDoubleFieldMapper toType(FieldMapper in) {
        return (AggregateMetricDoubleFieldMapper)in;
    }

    public static String subfieldName(String fieldName, Metric metric) {
        return fieldName + SUBFIELD_SEPARATOR + metric.name();
    }

    private AggregateMetricDoubleFieldMapper(String simpleName, MappedFieldType mappedFieldType, EnumMap<Metric, NumberFieldMapper> metricFieldMappers, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.ignoreMalformed = (Boolean)builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = (Boolean)builder.ignoreMalformed.getDefaultValue();
        this.metrics = (EnumSet)builder.metrics.getValue();
        this.defaultMetric = (Metric)((Object)builder.defaultMetric.getValue());
        this.metricFieldMappers = metricFieldMappers;
        this.metricType = (TimeSeriesParams.MetricType)builder.timeSeriesMetric.getValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.indexMode = builder.indexMode;
        this.indexSourceKeepMode = builder.indexSourceKeepMode;
    }

    public boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    Metric defaultMetric() {
        return this.defaultMetric;
    }

    public AggregateMetricDoubleFieldType fieldType() {
        return (AggregateMetricDoubleFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public Iterator<Mapper> iterator() {
        return Collections.emptyIterator();
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        NumberFieldMapper delegateFieldMapper;
        context.path().add(this.leafName());
        XContentSubParser subParser = null;
        EnumMap<Metric, Number> metricsParsed = new EnumMap<Metric, Number>(Metric.class);
        XContentBuilder malformedDataForSyntheticSource = null;
        try {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                context.path().remove();
                return;
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)context.parser());
            if (context.mappingLookup().isSourceSynthetic() && this.ignoreMalformed) {
                CopyingXContentParser copyingParser = new CopyingXContentParser(context.parser());
                malformedDataForSyntheticSource = copyingParser.getBuilder();
                subParser = new XContentSubParser((XContentParser)copyingParser);
            } else {
                subParser = new XContentSubParser(context.parser());
            }
            token = subParser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)subParser);
                String fieldName = subParser.currentName();
                Metric metric = Metric.valueOf(fieldName);
                if (!this.metrics.contains((Object)metric)) {
                    throw new IllegalArgumentException("Aggregate metric [" + String.valueOf((Object)metric) + "] does not exist in the mapping of field [" + this.mappedFieldType.name() + "]");
                }
                token = subParser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                delegateFieldMapper = this.metricFieldMappers.get((Object)metric);
                try {
                    Number metricValue = delegateFieldMapper.value(context.parser());
                    metricsParsed.put(metric, metricValue);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("failed to parse [" + metric.name() + "] sub field: " + e.getMessage(), e);
                }
                token = subParser.nextToken();
            }
            Number min = (Number)metricsParsed.get((Object)Metric.min);
            Number max = (Number)metricsParsed.get((Object)Metric.max);
            if (max != null && min != null && max.doubleValue() < min.doubleValue()) {
                throw new IllegalArgumentException("Aggregate metric field [" + this.mappedFieldType.name() + "] max value cannot be smaller than min value");
            }
            Number valueCount = (Number)metricsParsed.get((Object)Metric.value_count);
            if (valueCount != null && valueCount.intValue() < 0) {
                throw new IllegalArgumentException("Aggregate metric [" + String.valueOf((Object)Metric.value_count) + "] of field [" + this.mappedFieldType.name() + "] cannot be a negative number");
            }
            if (metricsParsed.size() != this.metrics.size()) {
                throw new IllegalArgumentException("Aggregate metric field [" + this.mappedFieldType.name() + "] must contain all metrics " + String.valueOf(this.metrics));
            }
            for (Metric m : metricsParsed.keySet()) {
                NumberFieldMapper delegateFieldMapper2 = this.metricFieldMappers.get((Object)m);
                if (context.doc().getByKey((Object)delegateFieldMapper2.fieldType().name()) == null) continue;
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] does not support indexing multiple values for the same field in the same document");
            }
        }
        catch (Exception e) {
            if (this.ignoreMalformed) {
                if (subParser != null) {
                    subParser.close();
                } else if (context.mappingLookup().isSourceSynthetic()) {
                    malformedDataForSyntheticSource = XContentBuilder.builder((XContent)context.parser().contentType().xContent()).copyCurrentStructure(context.parser());
                }
                if (malformedDataForSyntheticSource != null) {
                    context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField((String)this.fullPath(), malformedDataForSyntheticSource));
                }
                context.addIgnoredField(this.fullPath());
                context.path().remove();
                return;
            }
            throw e;
        }
        for (Map.Entry parsed : metricsParsed.entrySet()) {
            delegateFieldMapper = this.metricFieldMappers.get((Object)parsed.getKey());
            delegateFieldMapper.indexValue(context, (Number)parsed.getValue());
        }
        context.path().remove();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.ignoreMalformedByDefault, this.indexCreatedVersion, this.indexMode, this.indexSourceKeepMode).metric(this.metricType).init(this);
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), new CompositeSyntheticFieldLoader.Layer[]{new AggregateMetricSyntheticFieldLoader(this.fullPath(), this.metrics), new CompositeSyntheticFieldLoader.MalformedValuesLayer(this.fullPath())}));
    }

    public static enum Metric {
        min,
        max,
        sum,
        value_count;

    }

    public static final class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<EnumSet<Metric>> metrics = new FieldMapper.Parameter("metrics", false, () -> Defaults.METRICS, (n, c, o) -> {
            List metricsList = (List)o;
            EnumSet<Metric> parsedMetrics = EnumSet.noneOf(Metric.class);
            for (String s : metricsList) {
                try {
                    Metric m = Metric.valueOf(s);
                    parsedMetrics.add(m);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Metric [" + s + "] is not supported.", e);
                }
            }
            return parsedMetrics;
        }, m -> AggregateMetricDoubleFieldMapper.toType((FieldMapper)m).metrics, XContentBuilder::enumSet, Objects::toString).addValidator(v -> {
            if (v == null || v.isEmpty()) {
                throw new IllegalArgumentException("Property [metrics] is required for field [" + this.leafName() + "].");
            }
        });
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> timeSeriesMetric;
        private final FieldMapper.Parameter<Metric> defaultMetric = new FieldMapper.Parameter("default_metric", false, () -> null, (n, c, o) -> {
            try {
                return Metric.valueOf(o.toString());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Metric [" + o.toString() + "] is not supported.", e);
            }
        }, m -> AggregateMetricDoubleFieldMapper.toType((FieldMapper)m).defaultMetric, XContentBuilder::field, Objects::toString);
        private final IndexVersion indexCreatedVersion;
        private final IndexMode indexMode;
        private final Mapper.SourceKeepMode indexSourceKeepMode;

        public Builder(String name, Boolean ignoreMalformedByDefault, IndexVersion indexCreatedVersion, IndexMode mode, Mapper.SourceKeepMode indexSourceKeepMode) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.boolParam((String)"ignore_malformed", (boolean)true, m -> AggregateMetricDoubleFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
            this.timeSeriesMetric = TimeSeriesParams.metricParam(m -> AggregateMetricDoubleFieldMapper.toType((FieldMapper)m).metricType, (TimeSeriesParams.MetricType[])new TimeSeriesParams.MetricType[]{TimeSeriesParams.MetricType.GAUGE});
            this.indexCreatedVersion = Objects.requireNonNull(indexCreatedVersion);
            this.indexMode = mode;
            this.indexSourceKeepMode = indexSourceKeepMode;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.ignoreMalformed, this.metrics, this.defaultMetric, this.meta, this.timeSeriesMetric};
        }

        public Builder metric(TimeSeriesParams.MetricType metric) {
            this.timeSeriesMetric.setValue((Object)metric);
            return this;
        }

        public AggregateMetricDoubleFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "aggregate_metric_double_multifields", "Adding multifields to [aggregate_metric_double] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            if (!this.defaultMetric.isConfigured()) {
                if (((EnumSet)this.metrics.getValue()).size() == 1) {
                    Metric m = (Metric)((Object)((EnumSet)this.metrics.getValue()).iterator().next());
                    this.defaultMetric.setValue((Object)m);
                }
                if (!((EnumSet)this.metrics.getValue()).contains(this.defaultMetric.getValue())) {
                    throw new IllegalArgumentException("Property [default_metric] is required for field [" + this.leafName() + "].");
                }
            }
            if (!((EnumSet)this.metrics.getValue()).contains(this.defaultMetric.getValue())) {
                throw new IllegalArgumentException("Default metric [" + String.valueOf(this.defaultMetric.getValue()) + "] is not defined in the metrics of field [" + this.leafName() + "].");
            }
            EnumMap<Metric, NumberFieldMapper> metricMappers = new EnumMap<Metric, NumberFieldMapper>(Metric.class);
            for (Metric m : (EnumSet)this.metrics.getValue()) {
                String fieldName = AggregateMetricDoubleFieldMapper.subfieldName(this.leafName(), m);
                NumberFieldMapper.Builder builder = m == Metric.value_count ? new NumberFieldMapper.Builder(fieldName, NumberFieldMapper.NumberType.INTEGER, ScriptCompiler.NONE, false, false, this.indexCreatedVersion, this.indexMode, this.indexSourceKeepMode).allowMultipleValues(false) : new NumberFieldMapper.Builder(fieldName, NumberFieldMapper.NumberType.DOUBLE, ScriptCompiler.NONE, false, true, this.indexCreatedVersion, this.indexMode, this.indexSourceKeepMode).allowMultipleValues(false);
                NumberFieldMapper fieldMapper = builder.build(context);
                metricMappers.put(m, fieldMapper);
            }
            EnumMap metricFields = metricMappers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NumberFieldMapper)e.getValue()).fieldType(), (l, r) -> {
                throw new IllegalArgumentException("Duplicate keys " + String.valueOf(l) + "and " + String.valueOf(r) + AggregateMetricDoubleFieldMapper.SUBFIELD_SEPARATOR);
            }, () -> new EnumMap(Metric.class)));
            AggregateMetricDoubleFieldType metricFieldType = new AggregateMetricDoubleFieldType(context.buildFullName(this.leafName()), (Map)this.meta.getValue(), (TimeSeriesParams.MetricType)this.timeSeriesMetric.getValue());
            metricFieldType.setMetricFields(metricFields);
            metricFieldType.setDefaultMetric((Metric)((Object)this.defaultMetric.getValue()));
            return new AggregateMetricDoubleFieldMapper(this.leafName(), (MappedFieldType)metricFieldType, metricMappers, this.builderParams((Mapper.Builder)this, context), this);
        }
    }

    public static final class AggregateMetricDoubleFieldType
    extends SimpleMappedFieldType {
        private EnumMap<Metric, NumberFieldMapper.NumberFieldType> metricFields;
        private Metric defaultMetric;
        private final TimeSeriesParams.MetricType metricType;

        public AggregateMetricDoubleFieldType(String name) {
            this(name, Collections.emptyMap(), null);
        }

        public AggregateMetricDoubleFieldType(String name, Map<String, String> meta, TimeSeriesParams.MetricType metricType) {
            super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.metricType = metricType;
        }

        private NumberFieldMapper.NumberFieldType delegateFieldType(Metric metric) {
            return this.metricFields.get((Object)metric);
        }

        private NumberFieldMapper.NumberFieldType delegateFieldType() {
            return this.delegateFieldType(this.defaultMetric);
        }

        public String typeName() {
            return AggregateMetricDoubleFieldMapper.CONTENT_TYPE;
        }

        private void setMetricFields(EnumMap<Metric, NumberFieldMapper.NumberFieldType> metricFields) {
            this.metricFields = metricFields;
        }

        public Map<Metric, NumberFieldMapper.NumberFieldType> getMetricFields() {
            return Collections.unmodifiableMap(this.metricFields);
        }

        public void addMetricField(Metric m, NumberFieldMapper.NumberFieldType subfield) {
            if (this.metricFields == null) {
                this.metricFields = new EnumMap(Metric.class);
            }
            if (this.name() == null) {
                throw new IllegalArgumentException("Field of type [" + this.typeName() + "] must have a name before adding a subfield");
            }
            this.metricFields.put(m, subfield);
        }

        public void setDefaultMetric(Metric defaultMetric) {
            this.defaultMetric = defaultMetric;
        }

        Metric getDefaultMetric() {
            return this.defaultMetric;
        }

        public boolean mayExistInIndex(SearchExecutionContext context) {
            return this.delegateFieldType().mayExistInIndex(context);
        }

        public Query existsQuery(SearchExecutionContext context) {
            return this.delegateFieldType().existsQuery(context);
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot search for null.");
            }
            return this.delegateFieldType().termQuery(value, context);
        }

        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            return this.delegateFieldType().termsQuery(values, context);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            return this.delegateFieldType().rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
        }

        public Object valueForDisplay(Object value) {
            return this.delegateFieldType().valueForDisplay(value);
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return this.delegateFieldType().docValueFormat(format, timeZone);
        }

        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateMathParser, QueryRewriteContext context) throws IOException {
            return this.delegateFieldType().isFieldWithinQuery(reader, from, to, includeLower, includeUpper, timeZone, dateMathParser, context);
        }

        public boolean isAggregatable() {
            return true;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return (cache, breakerService) -> new IndexAggregateMetricDoubleFieldData(this.name(), AggregateMetricsValuesSourceType.AGGREGATE_METRIC){

                public LeafAggregateMetricDoubleFieldData load(final LeafReaderContext context) {
                    return new LeafAggregateMetricDoubleFieldData(){

                        @Override
                        public SortedNumericDoubleValues getAggregateMetricValues(final Metric metric) {
                            try {
                                final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)AggregateMetricDoubleFieldMapper.subfieldName(this.getFieldName(), metric));
                                return new SortedNumericDoubleValues(){

                                    public int docValueCount() {
                                        return values.docValueCount();
                                    }

                                    public boolean advanceExact(int doc) throws IOException {
                                        return values.advanceExact(doc);
                                    }

                                    public double nextValue() throws IOException {
                                        long v = values.nextValue();
                                        if (metric == Metric.value_count) {
                                            return v;
                                        }
                                        return NumericUtils.sortableLongToDouble((long)v);
                                    }
                                };
                            }
                            catch (IOException e) {
                                throw new IllegalStateException("Cannot load doc values", e);
                            }
                        }

                        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
                            return new DelegateDocValuesField((ScriptDocValues)new ScriptDocValues.Doubles((ScriptDocValues.Supplier)new ScriptDocValues.DoublesSupplier(this.getAggregateMetricValues(defaultMetric))), name);
                        }

                        public SortedBinaryDocValues getBytesValues() {
                            throw new UnsupportedOperationException("String representation of doc values for [aggregate_metric_double] fields is not supported");
                        }

                        public long ramBytesUsed() {
                            return 0L;
                        }
                    };
                }

                public LeafAggregateMetricDoubleFieldData loadDirect(LeafReaderContext context) {
                    return this.load(context);
                }

                public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                    return new SortedNumericSortField(this.delegateFieldType().name(), SortField.Type.DOUBLE, reverse);
                }

                public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                    throw new IllegalArgumentException("Can't sort on the [aggregate_metric_double] field");
                }
            };
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            return new AggregateMetricDoubleBlockLoader();
        }

        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }

        public class AggregateMetricDoubleBlockLoader
        extends BlockDocValuesReader.DocValuesBlockLoader {
            NumberFieldMapper.NumberFieldType minFieldType;
            NumberFieldMapper.NumberFieldType maxFieldType;
            NumberFieldMapper.NumberFieldType sumFieldType;
            NumberFieldMapper.NumberFieldType countFieldType;

            private AggregateMetricDoubleBlockLoader() {
                this.minFieldType = AggregateMetricDoubleFieldType.this.metricFields.get((Object)Metric.min);
                this.maxFieldType = AggregateMetricDoubleFieldType.this.metricFields.get((Object)Metric.max);
                this.sumFieldType = AggregateMetricDoubleFieldType.this.metricFields.get((Object)Metric.sum);
                this.countFieldType = AggregateMetricDoubleFieldType.this.metricFields.get((Object)Metric.value_count);
            }

            static NumericDocValues getNumericDocValues(NumberFieldMapper.NumberFieldType field, LeafReader leafReader) throws IOException {
                if (field == null) {
                    return null;
                }
                String fieldName = field.name();
                NumericDocValues values = leafReader.getNumericDocValues(fieldName);
                if (values != null) {
                    return values;
                }
                SortedNumericDocValues sortedValues = leafReader.getSortedNumericDocValues(fieldName);
                return DocValues.unwrapSingleton((SortedNumericDocValues)sortedValues);
            }

            public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
                final NumericDocValues minValues = AggregateMetricDoubleBlockLoader.getNumericDocValues(this.minFieldType, context.reader());
                final NumericDocValues maxValues = AggregateMetricDoubleBlockLoader.getNumericDocValues(this.maxFieldType, context.reader());
                final NumericDocValues sumValues = AggregateMetricDoubleBlockLoader.getNumericDocValues(this.sumFieldType, context.reader());
                final NumericDocValues valueCountValues = AggregateMetricDoubleBlockLoader.getNumericDocValues(this.countFieldType, context.reader());
                return new BlockDocValuesReader(){
                    private int docID = -1;

                    protected int docId() {
                        return this.docID;
                    }

                    public String toString() {
                        return "BlockDocValuesReader.AggregateMetricDouble";
                    }

                    public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
                        try (BlockLoader.AggregateMetricDoubleBuilder builder = factory.aggregateMetricDoubleBuilder(docs.count() - offset);){
                            this.copyDoubleValuesToBuilder(docs, offset, builder.min(), minValues);
                            this.copyDoubleValuesToBuilder(docs, offset, builder.max(), maxValues);
                            this.copyDoubleValuesToBuilder(docs, offset, builder.sum(), sumValues);
                            this.copyIntValuesToBuilder(docs, offset, builder.count(), valueCountValues);
                            BlockLoader.Block block = builder.build();
                            return block;
                        }
                    }

                    private void copyDoubleValuesToBuilder(BlockLoader.Docs docs, int offset, BlockLoader.DoubleBuilder builder, NumericDocValues values) throws IOException {
                        int lastDoc = -1;
                        for (int i = offset; i < docs.count(); ++i) {
                            int doc = docs.get(i);
                            if (doc < lastDoc) {
                                throw new IllegalStateException("docs within same block must be in order");
                            }
                            if (values == null || !values.advanceExact(doc)) {
                                builder.appendNull();
                                continue;
                            }
                            double value = NumericUtils.sortableLongToDouble((long)values.longValue());
                            lastDoc = doc;
                            this.docID = doc;
                            builder.appendDouble(value);
                        }
                    }

                    private void copyIntValuesToBuilder(BlockLoader.Docs docs, int offset, BlockLoader.IntBuilder builder, NumericDocValues values) throws IOException {
                        int lastDoc = -1;
                        for (int i = offset; i < docs.count(); ++i) {
                            int doc = docs.get(i);
                            if (doc < lastDoc) {
                                throw new IllegalStateException("docs within same block must be in order");
                            }
                            if (values == null || !values.advanceExact(doc)) {
                                builder.appendNull();
                                continue;
                            }
                            int value = Math.toIntExact(values.longValue());
                            lastDoc = doc;
                            this.docID = doc;
                            builder.appendInt(value);
                        }
                    }

                    public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
                        BlockLoader.AggregateMetricDoubleBuilder blockBuilder = (BlockLoader.AggregateMetricDoubleBuilder)builder;
                        this.docID = docId;
                        this.readSingleRow(docId, blockBuilder);
                    }

                    private void readSingleRow(int docId, BlockLoader.AggregateMetricDoubleBuilder builder) throws IOException {
                        if (minValues != null && minValues.advanceExact(docId)) {
                            builder.min().appendDouble(NumericUtils.sortableLongToDouble((long)minValues.longValue()));
                        } else {
                            builder.min().appendNull();
                        }
                        if (maxValues != null && maxValues.advanceExact(docId)) {
                            builder.max().appendDouble(NumericUtils.sortableLongToDouble((long)maxValues.longValue()));
                        } else {
                            builder.max().appendNull();
                        }
                        if (sumValues != null && sumValues.advanceExact(docId)) {
                            builder.sum().appendDouble(NumericUtils.sortableLongToDouble((long)sumValues.longValue()));
                        } else {
                            builder.sum().appendNull();
                        }
                        if (valueCountValues != null && valueCountValues.advanceExact(docId)) {
                            builder.count().appendInt(Math.toIntExact(valueCountValues.longValue()));
                        } else {
                            builder.count().appendNull();
                        }
                    }
                };
            }

            public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                return factory.aggregateMetricDoubleBuilder(expectedCount);
            }
        }
    }

    public static class AggregateMetricSyntheticFieldLoader
    implements CompositeSyntheticFieldLoader.DocValuesLayer {
        private final String name;
        private final EnumSet<Metric> metrics;
        private final Map<Metric, SortedNumericDocValues> metricDocValues = new EnumMap<Metric, SortedNumericDocValues>(Metric.class);
        private final Set<Metric> metricHasValue = EnumSet.noneOf(Metric.class);

        protected AggregateMetricSyntheticFieldLoader(String name, EnumSet<Metric> metrics) {
            this.name = name;
            this.metrics = metrics;
        }

        public String fieldName() {
            return this.name;
        }

        public long valueCount() {
            return this.hasValue() ? 1L : 0L;
        }

        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
            this.metricDocValues.clear();
            for (Metric m : this.metrics) {
                String fieldName = AggregateMetricDoubleFieldMapper.subfieldName(this.name, m);
                SortedNumericDocValues dv = SortedNumericDocValuesSyntheticFieldLoader.docValuesOrNull((LeafReader)reader, (String)fieldName);
                if (dv == null) continue;
                this.metricDocValues.put(m, dv);
            }
            if (this.metricDocValues.isEmpty()) {
                return null;
            }
            return new AggregateDocValuesLoader();
        }

        public boolean hasValue() {
            return !this.metricHasValue.isEmpty();
        }

        public void write(XContentBuilder b) throws IOException {
            if (this.metricHasValue.isEmpty()) {
                return;
            }
            b.startObject();
            for (Map.Entry<Metric, SortedNumericDocValues> entry : this.metricDocValues.entrySet()) {
                if (!this.metricHasValue.contains((Object)entry.getKey())) continue;
                String metricName = entry.getKey().name();
                long value = entry.getValue().nextValue();
                if (entry.getKey() == Metric.value_count) {
                    b.field(metricName, value);
                    continue;
                }
                b.field(metricName, NumericUtils.sortableLongToDouble((long)value));
            }
            b.endObject();
        }

        private class AggregateDocValuesLoader
        implements SourceLoader.SyntheticFieldLoader.DocValuesLoader {
            private AggregateDocValuesLoader() {
            }

            public boolean advanceToDoc(int docId) throws IOException {
                AggregateMetricSyntheticFieldLoader.this.metricHasValue.clear();
                for (Map.Entry<Metric, SortedNumericDocValues> e : AggregateMetricSyntheticFieldLoader.this.metricDocValues.entrySet()) {
                    if (!e.getValue().advanceExact(docId)) continue;
                    AggregateMetricSyntheticFieldLoader.this.metricHasValue.add(e.getKey());
                }
                return !AggregateMetricSyntheticFieldLoader.this.metricHasValue.isEmpty();
            }
        }
    }

    public static class Defaults {
        public static final EnumSet<Metric> METRICS = EnumSet.noneOf(Metric.class);
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
        public static final String METRICS = "metrics";
        public static final String DEFAULT_METRIC = "default_metric";
    }
}

