/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingResponse;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsResponse;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecuritySystemIndices;

public class SecurityMigrations {
    public static final Integer CLEANUP_ROLE_MAPPING_DUPLICATES_MIGRATION_VERSION = 2;
    public static final Integer ROLE_METADATA_FLATTENED_MIGRATION_VERSION = 3;
    private static final Logger logger = LogManager.getLogger(SecurityMigration.class);
    public static final TreeMap<Integer, SecurityMigration> MIGRATIONS_BY_VERSION = new TreeMap<Integer, RoleMetadataFlattenedMigration>(Map.of(CLEANUP_ROLE_MAPPING_DUPLICATES_MIGRATION_VERSION, new CleanupRoleMappingDuplicatesMigration(), ROLE_METADATA_FLATTENED_MIGRATION_VERSION, new RoleMetadataFlattenedMigration()));

    public static int highestMigrationVersion() {
        return MIGRATIONS_BY_VERSION.lastKey();
    }

    public static interface SecurityMigration {
        public void migrate(SecurityIndexManager var1, Client var2, ActionListener<Void> var3);

        public Set<NodeFeature> nodeFeaturesRequired();

        default public boolean checkPreConditions(SecurityIndexManager.State securityIndexManagerState) {
            return true;
        }

        public int minMappingVersion();
    }

    public static class CleanupRoleMappingDuplicatesMigration
    implements SecurityMigration {
        @Override
        public void migrate(SecurityIndexManager indexManager, Client client, ActionListener<Void> listener) {
            if (indexManager.getRoleMappingsCleanupMigrationStatus() == SecurityIndexManager.RoleMappingsCleanupMigrationStatus.SKIP) {
                listener.onResponse(null);
                return;
            }
            assert (indexManager.getRoleMappingsCleanupMigrationStatus() == SecurityIndexManager.RoleMappingsCleanupMigrationStatus.READY);
            this.getRoleMappings(client, (ActionListener<GetRoleMappingsResponse>)ActionListener.wrap(roleMappings -> {
                List<String> roleMappingsToDelete = CleanupRoleMappingDuplicatesMigration.getDuplicateRoleMappingNames(roleMappings.mappings());
                if (!roleMappingsToDelete.isEmpty()) {
                    logger.info("Found [" + roleMappingsToDelete.size() + "] role mapping(s) to cleanup in .security index.");
                    this.deleteNativeRoleMappings(client, roleMappingsToDelete, listener);
                } else {
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        private void getRoleMappings(Client client, ActionListener<GetRoleMappingsResponse> listener) {
            ClientHelper.executeAsyncWithOrigin((Client)client, (String)"security", (ActionType)GetRoleMappingsAction.INSTANCE, (ActionRequest)((GetRoleMappingsRequest)new GetRoleMappingsRequestBuilder((ElasticsearchClient)client).request()), listener);
        }

        private void deleteNativeRoleMappings(Client client, List<String> names, ActionListener<Void> listener) {
            assert (!names.isEmpty());
            GroupedActionListener groupListener = new GroupedActionListener(names.size(), ActionListener.wrap(responses -> {
                long foundRoleMappings = responses.stream().filter(DeleteRoleMappingResponse::isFound).count();
                if ((long)responses.size() > foundRoleMappings) {
                    logger.warn("[" + ((long)responses.size() - foundRoleMappings) + "] Role mapping(s) not found during role mapping clean up.");
                }
                if (foundRoleMappings > 0L) {
                    logger.info("Deleted [" + foundRoleMappings + "] duplicated role mapping(s) from .security index");
                }
                listener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
            for (String name : names) {
                ClientHelper.executeAsyncWithOrigin((Client)client, (String)"security", (ActionType)DeleteRoleMappingAction.INSTANCE, (ActionRequest)((DeleteRoleMappingRequest)((DeleteRoleMappingRequestBuilder)new DeleteRoleMappingRequestBuilder((ElasticsearchClient)client).name(name).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).request()), (ActionListener)groupListener);
            }
        }

        @Override
        public boolean checkPreConditions(SecurityIndexManager.State securityIndexManagerState) {
            return securityIndexManagerState.roleMappingsCleanupMigrationStatus == SecurityIndexManager.RoleMappingsCleanupMigrationStatus.READY || securityIndexManagerState.roleMappingsCleanupMigrationStatus == SecurityIndexManager.RoleMappingsCleanupMigrationStatus.SKIP;
        }

        @Override
        public Set<NodeFeature> nodeFeaturesRequired() {
            return Set.of(SecuritySystemIndices.SECURITY_ROLE_MAPPING_CLEANUP);
        }

        @Override
        public int minMappingVersion() {
            return SecuritySystemIndices.SecurityMainIndexMappingVersion.ADD_MANAGE_ROLES_PRIVILEGE.id();
        }

        protected static List<String> getDuplicateRoleMappingNames(ExpressionRoleMapping ... roleMappings) {
            Map<Boolean, List<ExpressionRoleMapping>> partitionedRoleMappings = Arrays.stream(roleMappings).collect(Collectors.partitioningBy(ExpressionRoleMapping::isReadOnly));
            Set clusterStateRoleMappings = partitionedRoleMappings.get(true).stream().map(ExpressionRoleMapping::getName).map(ExpressionRoleMapping::removeReadOnlySuffixIfPresent).collect(Collectors.toSet());
            return partitionedRoleMappings.get(false).stream().map(ExpressionRoleMapping::getName).filter(clusterStateRoleMappings::contains).toList();
        }
    }

    public static class RoleMetadataFlattenedMigration
    implements SecurityMigration {
        @Override
        public void migrate(SecurityIndexManager indexManager, Client client, ActionListener<Void> listener) {
            BoolQueryBuilder filterQuery = new BoolQueryBuilder().filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"role")).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"metadata_flattened"));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)filterQuery).size(0).trackTotalHits(true);
            SearchRequest countRequest = new SearchRequest(new String[]{indexManager.getConcreteIndexName()});
            countRequest.source(searchSourceBuilder);
            client.search(countRequest, ActionListener.wrap(response -> {
                if (!response.isTimedOut() && response.getFailedShards() == 0) {
                    if (response.getHits().getTotalHits() != null && response.getHits().getTotalHits().value > 0L) {
                        logger.info("Preparing to migrate [{}] roles", (Object)response.getHits().getTotalHits().value);
                        this.updateRolesByQuery(indexManager, client, filterQuery, listener);
                    } else {
                        listener.onResponse(null);
                    }
                } else {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("metadata_flattened migration SearchRequest failed", new Object[0])));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        private void updateRolesByQuery(SecurityIndexManager indexManager, Client client, BoolQueryBuilder filterQuery, ActionListener<Void> listener) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexManager.getConcreteIndexName()});
            updateByQueryRequest.setQuery((QueryBuilder)filterQuery);
            updateByQueryRequest.setAbortOnVersionConflict(false);
            updateByQueryRequest.setScript(new Script(ScriptType.INLINE, "painless", "if (ctx._source.metadata != null && ctx._source.metadata instanceof Map && !ctx._source.metadata.isEmpty()) {\n    ctx._source.metadata_flattened = ctx._source.metadata;\n} else {\n    ctx.op = 'noop';\n}\n", Collections.emptyMap()));
            client.admin().cluster().execute((ActionType)UpdateByQueryAction.INSTANCE, (ActionRequest)updateByQueryRequest, ActionListener.wrap(bulkByScrollResponse -> {
                logger.debug("metadata_flattened update-by-query completed: total=[{}], updated=[{}], conflicts=[{}], failures=[{}], searchFailures=[{}], noops=[{}], timedOut=[{}]", (Object)bulkByScrollResponse.getTotal(), (Object)bulkByScrollResponse.getUpdated(), (Object)bulkByScrollResponse.getVersionConflicts(), (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getSearchFailures().size(), (Object)bulkByScrollResponse.getNoops(), (Object)bulkByScrollResponse.isTimedOut());
                if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("metadata_flattened migration update-by-query failed with bulk update failures [{}]", new Object[]{bulkByScrollResponse.getBulkFailures()})));
                } else if (!bulkByScrollResponse.getSearchFailures().isEmpty()) {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("metadata_flattened migration update-by-query failed with search failures [{}]", new Object[]{bulkByScrollResponse.getSearchFailures()})));
                } else if (bulkByScrollResponse.isTimedOut()) {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("metadata_flattened migration update-by-query failed with timeout after [{}] seconds", new Object[]{bulkByScrollResponse.getTook().seconds()})));
                } else if (bulkByScrollResponse.getVersionConflicts() > 0L) {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("metadata_flattened migration update-by-query failed with version conflicts", new Object[0])));
                } else {
                    logger.info("metadata_flattened migration updated [{}] roles", (Object)bulkByScrollResponse.getUpdated());
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        @Override
        public Set<NodeFeature> nodeFeaturesRequired() {
            return Set.of(SecuritySystemIndices.SECURITY_ROLES_METADATA_FLATTENED);
        }

        @Override
        public int minMappingVersion() {
            return SecuritySystemIndices.SecurityMainIndexMappingVersion.ADD_REMOTE_CLUSTER_AND_DESCRIPTION_FIELDS.id();
        }
    }
}

