/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.time;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.function.Supplier;
import org.elasticsearch.core.TimeValue;

public interface RemainingTime
extends Supplier<TimeValue> {
    public static RemainingTime from(Supplier<Instant> currentTime, TimeValue remainingTime) {
        if (remainingTime.equals(TimeValue.MAX_VALUE)) {
            return () -> TimeValue.MAX_VALUE;
        }
        Instant timeout = currentTime.get().plus(remainingTime.duration(), remainingTime.timeUnit().toChronoUnit());
        long maxRemainingTime = remainingTime.nanos();
        return () -> {
            long remainingNanos = ChronoUnit.NANOS.between((Temporal)currentTime.get(), timeout);
            return TimeValue.timeValueNanos(Math.max(0L, Math.min(remainingNanos, maxRemainingTime)));
        };
    }
}

