/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.TransportStatus;

public class Header {
    private static final String RESPONSE_NAME = "NO_ACTION_NAME_FOR_RESPONSES";
    private final int networkMessageSize;
    private final TransportVersion version;
    private final long requestId;
    private final byte status;
    String actionName;
    Tuple<Map<String, String>, Map<String, Set<String>>> headers;
    private Compression.Scheme compressionScheme = null;

    Header(int networkMessageSize, long requestId, byte status, TransportVersion version) {
        this.networkMessageSize = networkMessageSize;
        this.version = version;
        this.requestId = requestId;
        this.status = status;
    }

    public int getNetworkMessageSize() {
        return this.networkMessageSize;
    }

    TransportVersion getVersion() {
        return this.version;
    }

    long getRequestId() {
        return this.requestId;
    }

    public boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }

    public boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    boolean isCompressed() {
        return TransportStatus.isCompress(this.status);
    }

    public String getActionName() {
        return this.actionName;
    }

    public Compression.Scheme getCompressionScheme() {
        return this.compressionScheme;
    }

    public Map<String, String> getRequestHeaders() {
        Tuple<Map<String, String>, Map<String, Set<String>>> allHeaders = this.getHeaders();
        return allHeaders == null ? null : allHeaders.v1();
    }

    boolean needsToReadVariableHeader() {
        return this.headers == null;
    }

    Tuple<Map<String, String>, Map<String, Set<String>>> getHeaders() {
        return this.headers;
    }

    void finishParsingHeader(StreamInput input) throws IOException {
        this.headers = ThreadContext.readHeadersFromStream(input);
        if (this.isRequest()) {
            if (this.version.before(TransportVersions.V_8_0_0)) {
                input.readStringArray();
            }
            this.actionName = input.readString();
        } else {
            this.actionName = RESPONSE_NAME;
        }
    }

    void setCompressionScheme(Compression.Scheme compressionScheme) {
        assert (this.isCompressed());
        this.compressionScheme = compressionScheme;
    }

    public String toString() {
        return "Header{" + this.networkMessageSize + "}{" + String.valueOf(this.version) + "}{" + this.requestId + "}{" + this.isRequest() + "}{" + this.isError() + "}{" + this.isHandshake() + "}{" + this.isCompressed() + "}{" + this.actionName + "}";
    }
}

