/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.Text;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class HighlightField
implements ToXContentFragment,
Writeable {
    private final String name;
    private final Text[] fragments;

    public HighlightField(StreamInput in) throws IOException {
        this(in.readString(), in.readOptionalArray(StreamInput::readText, Text[]::new));
    }

    public HighlightField(String name, Text[] fragments) {
        this.name = Objects.requireNonNull(name, "missing highlight field name");
        this.fragments = fragments;
    }

    public String name() {
        return this.name;
    }

    public Text[] fragments() {
        return this.fragments;
    }

    public String toString() {
        return "[" + this.name + "], fragments[" + Arrays.toString(this.fragments) + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (this.fragments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeArray(StreamOutput::writeText, this.fragments);
        }
    }

    public static HighlightField fromXContent(XContentParser parser) throws IOException {
        Text[] fragments;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String fieldName = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<Text> values = new ArrayList<Text>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                values.add(new Text(parser.text()));
            }
            fragments = values.toArray(Text.EMPTY_ARRAY);
        } else if (token == XContentParser.Token.VALUE_NULL) {
            fragments = null;
        } else {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token type [" + String.valueOf((Object)token) + "]", new Object[0]);
        }
        return new HighlightField(fieldName, fragments);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.name);
        if (this.fragments == null) {
            builder.nullValue();
        } else {
            builder.startArray();
            for (Text fragment : this.fragments) {
                builder.value(fragment);
            }
            builder.endArray();
        }
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HighlightField other = (HighlightField)obj;
        return Objects.equals(this.name, other.name) && Arrays.equals(this.fragments, other.fragments);
    }

    public final int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.fragments));
    }
}

