/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.useragent;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ingest.useragent.DeviceTypeParser;
import org.elasticsearch.ingest.useragent.UserAgentCache;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

final class UserAgentParser {
    private final UserAgentCache cache;
    private final DeviceTypeParser deviceTypeParser = new DeviceTypeParser();
    private final List<UserAgentSubpattern> uaPatterns = new ArrayList<UserAgentSubpattern>();
    private final List<UserAgentSubpattern> osPatterns = new ArrayList<UserAgentSubpattern>();
    private final List<UserAgentSubpattern> devicePatterns = new ArrayList<UserAgentSubpattern>();
    private final String name;

    UserAgentParser(String name, InputStream regexStream, InputStream deviceTypeRegexStream, UserAgentCache cache) {
        this.name = name;
        this.cache = cache;
        try {
            this.init(regexStream);
            if (deviceTypeRegexStream != null) {
                this.deviceTypeParser.init(deviceTypeRegexStream);
            }
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("error parsing regular expression file", (Throwable)e, new Object[0]);
        }
    }

    private void init(InputStream regexStream) throws IOException {
        block16: {
            try (XContentParser yamlParser = XContentFactory.xContent(XContentType.YAML).createParser(XContentParserConfiguration.EMPTY, regexStream);){
                XContentParser.Token token = yamlParser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) break block16;
                token = yamlParser.nextToken();
                while (token != null) {
                    if (token == XContentParser.Token.FIELD_NAME && yamlParser.currentName().equals("user_agent_parsers")) {
                        parserConfigurations = UserAgentParser.readParserConfigurations(yamlParser);
                        for (Map<String, String> map : parserConfigurations) {
                            this.uaPatterns.add(new UserAgentSubpattern(UserAgentParser.compilePattern(map.get("regex"), map.get("regex_flag")), map.get("family_replacement"), map.get("v1_replacement"), map.get("v2_replacement"), map.get("v3_replacement"), map.get("v4_replacement")));
                        }
                    } else if (token == XContentParser.Token.FIELD_NAME && yamlParser.currentName().equals("os_parsers")) {
                        parserConfigurations = UserAgentParser.readParserConfigurations(yamlParser);
                        for (Map<String, String> map : parserConfigurations) {
                            this.osPatterns.add(new UserAgentSubpattern(UserAgentParser.compilePattern(map.get("regex"), map.get("regex_flag")), map.get("os_replacement"), map.get("os_v1_replacement"), map.get("os_v2_replacement"), map.get("os_v3_replacement"), map.get("os_v4_replacement")));
                        }
                    } else if (token == XContentParser.Token.FIELD_NAME && yamlParser.currentName().equals("device_parsers")) {
                        parserConfigurations = UserAgentParser.readParserConfigurations(yamlParser);
                        for (Map<String, String> map : parserConfigurations) {
                            this.devicePatterns.add(new UserAgentSubpattern(UserAgentParser.compilePattern(map.get("regex"), map.get("regex_flag")), map.get("device_replacement"), null, null, null, null));
                        }
                    }
                    token = yamlParser.nextToken();
                }
            }
        }
        if (this.uaPatterns.isEmpty() && this.osPatterns.isEmpty() && this.devicePatterns.isEmpty()) {
            throw new ElasticsearchParseException("not a valid regular expression file", new Object[0]);
        }
    }

    private static Pattern compilePattern(String regex, String regex_flag) {
        if (regex_flag != null && regex_flag.equals("i")) {
            return Pattern.compile(regex, 2);
        }
        return Pattern.compile(regex);
    }

    static List<Map<String, String>> readParserConfigurations(XContentParser yamlParser) throws IOException {
        ArrayList<Map<String, String>> patternList = new ArrayList<Map<String, String>>();
        XContentParser.Token token = yamlParser.nextToken();
        if (token != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("malformed regular expression file, should continue with 'array' after 'object'", new Object[0]);
        }
        token = yamlParser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("malformed regular expression file, expecting 'object'", new Object[0]);
        }
        while (token == XContentParser.Token.START_OBJECT) {
            token = yamlParser.nextToken();
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ElasticsearchParseException("malformed regular expression file, should continue with 'field_name' after 'array'", new Object[0]);
            }
            HashMap<String, String> regexMap = new HashMap<String, String>();
            while (token == XContentParser.Token.FIELD_NAME) {
                String fieldName = yamlParser.currentName();
                token = yamlParser.nextToken();
                String fieldValue = yamlParser.text();
                regexMap.put(fieldName, fieldValue);
                token = yamlParser.nextToken();
            }
            patternList.add(regexMap);
            token = yamlParser.nextToken();
        }
        return patternList;
    }

    List<UserAgentSubpattern> getUaPatterns() {
        return this.uaPatterns;
    }

    List<UserAgentSubpattern> getOsPatterns() {
        return this.osPatterns;
    }

    List<UserAgentSubpattern> getDevicePatterns() {
        return this.devicePatterns;
    }

    String getName() {
        return this.name;
    }

    public Details parse(String agentString, boolean extractDeviceType) {
        Details details = this.cache.get(this.name, agentString);
        if (details == null) {
            VersionedName userAgent = UserAgentParser.findMatch(this.uaPatterns, agentString);
            VersionedName operatingSystem = UserAgentParser.findMatch(this.osPatterns, agentString);
            VersionedName device = UserAgentParser.findMatch(this.devicePatterns, agentString);
            String deviceType = extractDeviceType ? this.deviceTypeParser.findDeviceType(agentString, userAgent, operatingSystem, device) : null;
            details = new Details(userAgent, operatingSystem, device, deviceType);
            this.cache.put(this.name, agentString, details);
        }
        return details;
    }

    private static VersionedName findMatch(List<UserAgentSubpattern> possiblePatterns, String agentString) {
        for (UserAgentSubpattern pattern : possiblePatterns) {
            VersionedName versionedName = pattern.match(agentString);
            if (versionedName == null) continue;
            return versionedName;
        }
        return null;
    }

    record UserAgentSubpattern(Pattern pattern, String nameReplacement, String v1Replacement, String v2Replacement, String v3Replacement, String v4Replacement) {
        public VersionedName match(String agentString) {
            String name = null;
            String major = null;
            String minor = null;
            String patch = null;
            String build = null;
            Matcher matcher = this.pattern.matcher(agentString);
            if (!matcher.find()) {
                return null;
            }
            int groupCount = matcher.groupCount();
            if (this.nameReplacement != null) {
                name = this.nameReplacement.contains("$1") && groupCount >= 1 && matcher.group(1) != null ? this.nameReplacement.replaceFirst("\\$1", Matcher.quoteReplacement(matcher.group(1))) : this.nameReplacement;
            } else if (groupCount >= 1) {
                name = matcher.group(1);
            }
            if (this.v1Replacement != null) {
                major = this.v1Replacement;
            } else if (groupCount >= 2) {
                major = matcher.group(2);
            }
            if (this.v2Replacement != null) {
                minor = this.v2Replacement;
            } else if (groupCount >= 3) {
                minor = matcher.group(3);
            }
            if (this.v3Replacement != null) {
                patch = this.v3Replacement;
            } else if (groupCount >= 4) {
                patch = matcher.group(4);
            }
            if (this.v4Replacement != null) {
                build = this.v4Replacement;
            } else if (groupCount >= 5) {
                build = matcher.group(5);
            }
            return name == null ? null : new VersionedName(name, major, minor, patch, build);
        }
    }

    record Details(VersionedName userAgent, VersionedName operatingSystem, VersionedName device, String deviceType) {
    }

    record VersionedName(String name, String major, String minor, String patch, String build) {
    }
}

