/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.FieldArrayContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

public class SortedNumericWithOffsetsDocValuesSyntheticFieldLoaderLayer
implements CompositeSyntheticFieldLoader.DocValuesLayer {
    private final String fullPath;
    private final String offsetsFieldName;
    private final NumericValueWriter valueWriter;
    private NumericDocValuesWithOffsetsLoader docValuesLoader;

    public SortedNumericWithOffsetsDocValuesSyntheticFieldLoaderLayer(String fullPath, String offsetsFieldName, NumericValueWriter valueWriter) {
        this.fullPath = fullPath;
        this.offsetsFieldName = offsetsFieldName;
        this.valueWriter = valueWriter;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        SortedNumericDocValues valueDocValues = DocValues.getSortedNumeric(leafReader, this.fullPath);
        SortedDocValues offsetDocValues = DocValues.getSorted(leafReader, this.offsetsFieldName);
        this.docValuesLoader = new NumericDocValuesWithOffsetsLoader(valueDocValues, offsetDocValues, this.valueWriter);
        return this.docValuesLoader;
    }

    @Override
    public boolean hasValue() {
        return this.docValuesLoader != null && this.docValuesLoader.hasValue();
    }

    @Override
    public long valueCount() {
        if (this.docValuesLoader != null) {
            return this.docValuesLoader.count();
        }
        return 0L;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        if (this.docValuesLoader != null) {
            this.docValuesLoader.write(b);
        }
    }

    @Override
    public String fieldName() {
        return this.fullPath;
    }

    @FunctionalInterface
    public static interface NumericValueWriter {
        public void writeLongValue(XContentBuilder var1, long var2) throws IOException;
    }

    private static final class NumericDocValuesWithOffsetsLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader {
        private final SortedDocValues offsetDocValues;
        private final SortedNumericDocValues valueDocValues;
        private final NumericValueWriter writer;
        private final ByteArrayStreamInput scratch = new ByteArrayStreamInput();
        private boolean hasValue;
        private boolean hasOffset;
        private int[] offsetToOrd;

        NumericDocValuesWithOffsetsLoader(SortedNumericDocValues valueDocValues, SortedDocValues offsetDocValues, NumericValueWriter writer) {
            this.valueDocValues = valueDocValues;
            this.offsetDocValues = offsetDocValues;
            this.writer = writer;
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.valueDocValues.advanceExact(docId);
            this.hasOffset = this.offsetDocValues.advanceExact(docId);
            if (this.hasValue || this.hasOffset) {
                if (this.hasOffset) {
                    int offsetOrd = this.offsetDocValues.ordValue();
                    BytesRef encodedValue = this.offsetDocValues.lookupOrd(offsetOrd);
                    this.scratch.reset(encodedValue.bytes, encodedValue.offset, encodedValue.length);
                    this.offsetToOrd = FieldArrayContext.parseOffsetArray(this.scratch);
                } else {
                    this.offsetToOrd = null;
                }
                return true;
            }
            this.offsetToOrd = null;
            return false;
        }

        public boolean hasValue() {
            return this.hasOffset || this.hasValue && this.valueDocValues.docValueCount() > 0;
        }

        public int count() {
            if (this.hasValue) {
                if (this.offsetToOrd != null) {
                    return this.offsetToOrd.length + 1;
                }
                return this.valueDocValues.docValueCount();
            }
            if (this.hasOffset) {
                return 2;
            }
            return 0;
        }

        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue && !this.hasOffset) {
                return;
            }
            if (this.offsetToOrd != null && this.hasValue) {
                int count = this.valueDocValues.docValueCount();
                long[] values = new long[count];
                int duplicates = 0;
                for (int i = 0; i < count; ++i) {
                    long value = this.valueDocValues.nextValue();
                    if (i > 0 && value == values[i - duplicates - 1]) {
                        ++duplicates;
                        continue;
                    }
                    values[i - duplicates] = value;
                }
                for (int offset : this.offsetToOrd) {
                    if (offset == -1) {
                        b.nullValue();
                        continue;
                    }
                    this.writer.writeLongValue(b, values[offset]);
                }
            } else if (this.offsetToOrd != null) {
                for (int offset : this.offsetToOrd) {
                    assert (offset == -1);
                    b.nullValue();
                }
            } else {
                for (int i = 0; i < this.valueDocValues.docValueCount(); ++i) {
                    this.writer.writeLongValue(b, this.valueDocValues.nextValue());
                }
            }
        }
    }
}

