/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.lucene912.Lucene912Codec;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.codec.CodecProvider;
import org.elasticsearch.index.codec.DeduplicatingFieldInfosFormat;
import org.elasticsearch.index.codec.LegacyPerFieldMapperCodec;
import org.elasticsearch.index.codec.PerFieldMapperCodec;
import org.elasticsearch.index.codec.zstd.Zstd814StoredFieldsFormat;
import org.elasticsearch.index.mapper.MapperService;

public class CodecService
implements CodecProvider {
    public static final FeatureFlag ZSTD_STORED_FIELDS_FEATURE_FLAG = new FeatureFlag("zstd_stored_fields");
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String LEGACY_DEFAULT_CODEC = "legacy_default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LEGACY_BEST_COMPRESSION_CODEC = "legacy_best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService(@Nullable MapperService mapperService, BigArrays bigArrays) {
        HashMap<String, Codec> codecs = new HashMap<String, Codec>();
        LegacyPerFieldMapperCodec legacyBestSpeedCodec = new LegacyPerFieldMapperCodec(Lucene912Codec.Mode.BEST_SPEED, mapperService, bigArrays);
        if (ZSTD_STORED_FIELDS_FEATURE_FLAG.isEnabled()) {
            codecs.put(DEFAULT_CODEC, new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_SPEED, mapperService, bigArrays));
        } else {
            codecs.put(DEFAULT_CODEC, legacyBestSpeedCodec);
        }
        codecs.put(LEGACY_DEFAULT_CODEC, legacyBestSpeedCodec);
        codecs.put(BEST_COMPRESSION_CODEC, new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_COMPRESSION, mapperService, bigArrays));
        LegacyPerFieldMapperCodec legacyBestCompressionCodec = new LegacyPerFieldMapperCodec(Lucene912Codec.Mode.BEST_COMPRESSION, mapperService, bigArrays);
        codecs.put(LEGACY_BEST_COMPRESSION_CODEC, legacyBestCompressionCodec);
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName(codec));
        }
        this.codecs = codecs.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> {
            Codec codec = (Codec)e.getValue();
            if (codec instanceof DeduplicateFieldInfosCodec) {
                return codec;
            }
            return new DeduplicateFieldInfosCodec(codec.getName(), codec);
        }));
    }

    @Override
    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    @Override
    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }

    public static class DeduplicateFieldInfosCodec
    extends FilterCodec {
        private final DeduplicatingFieldInfosFormat deduplicatingFieldInfosFormat = new DeduplicatingFieldInfosFormat(super.fieldInfosFormat());

        protected DeduplicateFieldInfosCodec(String name, Codec delegate) {
            super(name, delegate);
        }

        @Override
        public final FieldInfosFormat fieldInfosFormat() {
            return this.deduplicatingFieldInfosFormat;
        }

        public final Codec delegate() {
            return this.delegate;
        }
    }
}

