/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class InferenceFieldMetadata
implements SimpleDiffable<InferenceFieldMetadata>,
ToXContentFragment {
    private static final String INFERENCE_ID_FIELD = "inference_id";
    private static final String SEARCH_INFERENCE_ID_FIELD = "search_inference_id";
    private static final String SOURCE_FIELDS_FIELD = "source_fields";
    static final String CHUNKING_SETTINGS_FIELD = "chunking_settings";
    private final String name;
    private final String inferenceId;
    private final String searchInferenceId;
    private final String[] sourceFields;
    private final Map<String, Object> chunkingSettings;

    public InferenceFieldMetadata(String name, String inferenceId, String[] sourceFields, Map<String, Object> chunkingSettings) {
        this(name, inferenceId, inferenceId, sourceFields, chunkingSettings);
    }

    public InferenceFieldMetadata(String name, String inferenceId, String searchInferenceId, String[] sourceFields, Map<String, Object> chunkingSettings) {
        this.name = Objects.requireNonNull(name);
        this.inferenceId = Objects.requireNonNull(inferenceId);
        this.searchInferenceId = Objects.requireNonNull(searchInferenceId);
        this.sourceFields = Objects.requireNonNull(sourceFields);
        this.chunkingSettings = chunkingSettings != null ? Map.copyOf(chunkingSettings) : null;
    }

    public InferenceFieldMetadata(StreamInput input) throws IOException {
        this.name = input.readString();
        this.inferenceId = input.readString();
        this.searchInferenceId = input.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? input.readString() : this.inferenceId;
        this.sourceFields = input.readStringArray();
        this.chunkingSettings = input.getTransportVersion().onOrAfter(TransportVersions.SEMANTIC_TEXT_CHUNKING_CONFIG_8_19) ? input.readGenericMap() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.inferenceId);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            out.writeString(this.searchInferenceId);
        }
        out.writeStringArray(this.sourceFields);
        if (out.getTransportVersion().onOrAfter(TransportVersions.SEMANTIC_TEXT_CHUNKING_CONFIG_8_19)) {
            out.writeGenericMap(this.chunkingSettings);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceFieldMetadata that = (InferenceFieldMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.searchInferenceId, that.searchInferenceId) && Arrays.equals(this.sourceFields, that.sourceFields) && Objects.equals(this.chunkingSettings, that.chunkingSettings);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.inferenceId, this.searchInferenceId, this.chunkingSettings);
        result = 31 * result + Arrays.hashCode(this.sourceFields);
        return result;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public String getInferenceId() {
        return this.inferenceId;
    }

    public String getSearchInferenceId() {
        return this.searchInferenceId;
    }

    public String[] getSourceFields() {
        return this.sourceFields;
    }

    public Map<String, Object> getChunkingSettings() {
        return this.chunkingSettings;
    }

    public static Diff<InferenceFieldMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(InferenceFieldMetadata::new, in);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(INFERENCE_ID_FIELD, this.inferenceId);
        if (!this.searchInferenceId.equals(this.inferenceId)) {
            builder.field(SEARCH_INFERENCE_ID_FIELD, this.searchInferenceId);
        }
        builder.array(SOURCE_FIELDS_FIELD, this.sourceFields);
        if (this.chunkingSettings != null) {
            builder.startObject(CHUNKING_SETTINGS_FIELD);
            builder.mapContents(this.chunkingSettings);
            builder.endObject();
        }
        return builder.endObject();
    }

    public static InferenceFieldMetadata fromXContent(XContentParser parser) throws IOException {
        String name = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        Objects.requireNonNull(token, "Expected InferenceFieldMetadata but got EOF");
        String currentFieldName = null;
        String inferenceId = null;
        String searchInferenceId = null;
        Map<String, Object> chunkingSettings = null;
        ArrayList<String> inputFields = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (INFERENCE_ID_FIELD.equals(currentFieldName)) {
                    inferenceId = parser.text();
                    continue;
                }
                if (!SEARCH_INFERENCE_ID_FIELD.equals(currentFieldName)) continue;
                searchInferenceId = parser.text();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!SOURCE_FIELDS_FIELD.equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        inputFields.add(parser.text());
                        continue;
                    }
                    parser.skipChildren();
                }
                continue;
            }
            if (CHUNKING_SETTINGS_FIELD.equals(currentFieldName)) {
                chunkingSettings = parser.map();
                continue;
            }
            parser.skipChildren();
        }
        return new InferenceFieldMetadata(name, inferenceId, searchInferenceId == null ? inferenceId : searchInferenceId, (String[])inputFields.toArray(String[]::new), chunkingSettings);
    }
}

