/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpdateFilterResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateFilterRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> addItems;
    @Nullable
    private final String description;
    private final String filterId;
    private final List<String> removeItems;
    public static final JsonpDeserializer<UpdateFilterRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateFilterRequest::setupUpdateFilterRequestDeserializer);
    public static final Endpoint<UpdateFilterRequest, UpdateFilterResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateFilterRequest, UpdateFilterResponse>("es/ml.update_filter", request -> "POST", request -> {
        boolean _filterId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.filterId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _filterId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("filterId", request.filterId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateFilterResponse._DESERIALIZER);

    private UpdateFilterRequest(Builder builder) {
        this.addItems = ApiTypeHelper.unmodifiable(builder.addItems);
        this.description = builder.description;
        this.filterId = ApiTypeHelper.requireNonNull(builder.filterId, this, "filterId");
        this.removeItems = ApiTypeHelper.unmodifiable(builder.removeItems);
    }

    public static UpdateFilterRequest of(Function<Builder, ObjectBuilder<UpdateFilterRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> addItems() {
        return this.addItems;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final List<String> removeItems() {
        return this.removeItems;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.addItems)) {
            generator.writeKey("add_items");
            generator.writeStartArray();
            for (String item0 : this.addItems) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.removeItems)) {
            generator.writeKey("remove_items");
            generator.writeStartArray();
            for (String item0 : this.removeItems) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUpdateFilterRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::addItems, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "add_items");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::removeItems, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "remove_items");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateFilterRequest> {
        @Nullable
        private List<String> addItems;
        @Nullable
        private String description;
        private String filterId;
        @Nullable
        private List<String> removeItems;

        public final Builder addItems(List<String> list) {
            this.addItems = Builder._listAddAll(this.addItems, list);
            return this;
        }

        public final Builder addItems(String value, String ... values) {
            this.addItems = Builder._listAdd(this.addItems, value, values);
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public final Builder removeItems(List<String> list) {
            this.removeItems = Builder._listAddAll(this.removeItems, list);
            return this;
        }

        public final Builder removeItems(String value, String ... values) {
            this.removeItems = Builder._listAdd(this.removeItems, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateFilterRequest build() {
            this._checkSingleUse();
            return new UpdateFilterRequest(this);
        }
    }
}

