/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transform;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.core.watcher.transform.chain.ChainTransformFactory;

public final class TransformRegistry {
    private final Map<String, TransformFactory<? extends Transform, ? extends Transform.Result, ? extends ExecutableTransform<?, ?>>> factories;

    public TransformRegistry(Map<String, TransformFactory<? extends Transform, ? extends Transform.Result, ? extends ExecutableTransform<?, ?>>> factories) {
        HashMap map = new HashMap(factories);
        map.put("chain", new ChainTransformFactory(this));
        this.factories = Collections.unmodifiableMap(map);
    }

    public TransformFactory<? extends Transform, ? extends Transform.Result, ? extends ExecutableTransform<?, ?>> factory(String type) {
        return this.factories.get(type);
    }

    public ExecutableTransform<? extends Transform, ? extends Transform.Result> parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        ExecutableTransform<? extends Transform, ? extends Transform.Result> transform = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (type == null) continue;
            transform = this.parse(watchId, type, parser);
        }
        return transform;
    }

    private ExecutableTransform<? extends Transform, ? extends Transform.Result> parse(String watchId, String type, XContentParser parser) throws IOException {
        TransformFactory<Transform, Transform.Result, ExecutableTransform<?, ?>> factory = this.factories.get(type);
        if (factory == null) {
            throw new ElasticsearchParseException("could not parse transform for watch [{}], unknown transform type [{}]", watchId, type);
        }
        return factory.parseExecutable(watchId, parser);
    }

    public Transform parseTransform(String watchId, String type, XContentParser parser) throws IOException {
        TransformFactory<Transform, Transform.Result, ExecutableTransform<?, ?>> factory = this.factories.get(type);
        if (factory == null) {
            throw new ElasticsearchParseException("could not parse transform for watch [{}], unknown transform type [{}]", watchId, type);
        }
        return factory.parseTransform(watchId, parser);
    }
}

