/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;

public record TextEmbeddingBitResults(List<TextEmbeddingByteResults.Embedding> embeddings) implements TextEmbeddingResults<TextEmbeddingByteResults.Embedding>
{
    public static final String NAME = "text_embedding_service_bit_results";
    public static final String TEXT_EMBEDDING_BITS = "text_embedding_bits";

    public TextEmbeddingBitResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(TextEmbeddingByteResults.Embedding::new));
    }

    @Override
    public int getFirstEmbeddingSize() {
        if (this.embeddings.isEmpty()) {
            throw new IllegalStateException("Embeddings list is empty");
        }
        return 8 * this.embeddings.get(0).values().length;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).array(TEXT_EMBEDDING_BITS, this.embeddings.iterator());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> new MlTextEmbeddingResults(TEXT_EMBEDDING_BITS, embedding.toDoubleArray(), false)).toList();
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        LegacyTextEmbeddingResults legacyEmbedding = new LegacyTextEmbeddingResults(this.embeddings.stream().map(embedding -> new LegacyTextEmbeddingResults.Embedding(embedding.toFloatArray())).toList());
        return List.of(legacyEmbedding);
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TEXT_EMBEDDING_BITS, this.embeddings);
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextEmbeddingBitResults that = (TextEmbeddingBitResults)o;
        return Objects.equals(this.embeddings, that.embeddings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.embeddings);
    }
}

