/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TotalHitCountCollector;

class PartialHitCountCollector
extends TotalHitCountCollector {
    private final HitsThresholdChecker hitsThresholdChecker;
    private boolean earlyTerminated;

    PartialHitCountCollector(HitsThresholdChecker hitsThresholdChecker) {
        this.hitsThresholdChecker = hitsThresholdChecker;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.hitsThresholdChecker.totalHitsThreshold == Integer.MAX_VALUE ? super.scoreMode() : ScoreMode.TOP_DOCS;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (this.hitsThresholdChecker.totalHitsThreshold == Integer.MAX_VALUE) {
            return super.getLeafCollector(context);
        }
        this.earlyTerminateIfNeeded();
        return new FilterLeafCollector(super.getLeafCollector(context)){

            @Override
            public void collect(int doc) throws IOException {
                PartialHitCountCollector.this.earlyTerminateIfNeeded();
                PartialHitCountCollector.this.hitsThresholdChecker.incrementHitCount();
                super.collect(doc);
            }
        };
    }

    private void earlyTerminateIfNeeded() {
        if (this.hitsThresholdChecker.isThresholdReached()) {
            this.earlyTerminated = true;
            throw new CollectionTerminatedException();
        }
    }

    boolean hasEarlyTerminated() {
        return this.earlyTerminated;
    }

    static class HitsThresholdChecker {
        private final int totalHitsThreshold;
        private final AtomicInteger numCollected = new AtomicInteger();

        HitsThresholdChecker(int totalHitsThreshold) {
            this.totalHitsThreshold = totalHitsThreshold;
        }

        void incrementHitCount() {
            this.numCollected.incrementAndGet();
        }

        boolean isThresholdReached() {
            return this.numCollected.getAcquire() >= this.totalHitsThreshold;
        }
    }
}

