/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.useragent;

import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.ingest.useragent.UserAgentParser;

class UserAgentCache {
    private final Cache<CompositeCacheKey, UserAgentParser.Details> cache;

    UserAgentCache(long cacheSize) {
        this.cache = CacheBuilder.builder().setMaximumWeight(cacheSize).build();
    }

    public UserAgentParser.Details get(String parserName, String userAgent) {
        return this.cache.get(new CompositeCacheKey(parserName, userAgent));
    }

    public void put(String parserName, String userAgent, UserAgentParser.Details details) {
        this.cache.put(new CompositeCacheKey(parserName, userAgent), details);
    }

    private record CompositeCacheKey(String parserName, String userAgent) {
    }
}

