/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Point;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SimpleVectorTileFormatter;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherMultiGeoPointIndexFieldData;
import org.elasticsearch.index.fielddata.plain.LatLonPointIndexFieldData;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.SortedNumericDocValuesLongFieldScript;
import org.elasticsearch.script.field.GeoPointDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.runtime.GeoPointScriptFieldDistanceFeatureQuery;
import org.elasticsearch.xcontent.CopyingXContentParser;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.Text;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentString;

public class GeoPointFieldMapper
extends AbstractPointGeometryFieldMapper<GeoPoint> {
    public static final String CONTENT_TYPE = "geo_point";
    private static final IndexVersion MINIMUM_COMPATIBILITY_VERSION = IndexVersion.fromId(5000099);
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.scriptCompiler(), (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings()), c.indexVersionCreated(), c.getIndexSettings().getMode()), MINIMUM_COMPATIBILITY_VERSION);
    private final Builder builder;
    private final FieldValues<GeoPoint> scriptValues;
    private final IndexVersion indexCreatedVersion;
    private final TimeSeriesParams.MetricType metricType;
    private final IndexMode indexMode;
    private final boolean indexed;

    private static Builder builder(FieldMapper in) {
        return GeoPointFieldMapper.toType((FieldMapper)in).builder;
    }

    private static GeoPointFieldMapper toType(FieldMapper in) {
        return (GeoPointFieldMapper)in;
    }

    public GeoPointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, AbstractGeometryFieldMapper.Parser<GeoPoint> parser, Builder builder) {
        super(simpleName, mappedFieldType, builderParams, builder.ignoreMalformed.get(), builder.ignoreZValue.get(), builder.nullValue.get(), parser);
        this.builder = builder;
        this.scriptValues = builder.scriptValues();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.metricType = builder.metric.get();
        this.indexMode = builder.indexMode;
        this.indexed = builder.indexed.get();
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.builder.scriptCompiler, this.builder.ignoreMalformed.getDefaultValue().value(), this.indexCreatedVersion, this.indexMode).init(this);
    }

    @Override
    protected void index(DocumentParserContext context, GeoPoint geometry) throws IOException {
        boolean indexed = this.fieldType().isIndexed();
        boolean hasDocValues = this.fieldType().hasDocValues();
        boolean store = this.fieldType().isStored();
        if (indexed && hasDocValues) {
            context.doc().add(new LatLonPointWithDocValues(this.fieldType().name(), geometry.lat(), geometry.lon()));
        } else if (hasDocValues) {
            context.doc().add(new LatLonDocValuesField(this.fieldType().name(), geometry.lat(), geometry.lon()));
        } else if (indexed) {
            context.doc().add(new LatLonPoint(this.fieldType().name(), geometry.lat(), geometry.lon()));
        }
        if (store) {
            context.doc().add(new StoredField(this.fieldType().name(), geometry.toString()));
        }
        if (!hasDocValues && (indexed || store)) {
            context.addToFieldNames(this.fieldType().name());
        }
        DocumentParserContext parserContext = context.switchParser(new GeoHashMultiFieldParser(context.parser(), geometry.geohash()));
        this.multiFields().parse(this, context, () -> parserContext);
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, point -> {
            try {
                this.index(documentParserContext, (GeoPoint)point);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void onMalformedValue(DocumentParserContext context, XContentBuilder malformedDataForSyntheticSource, Exception cause) throws IOException {
        super.onMalformedValue(context, malformedDataForSyntheticSource, cause);
        if (malformedDataForSyntheticSource != null) {
            context.doc().add(IgnoreMalformedStoredValues.storedField(this.fullPath(), malformedDataForSyntheticSource));
        }
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.fieldType().hasDocValues()) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new SortedNumericDocValuesSyntheticFieldLoader(this.fullPath(), this.leafName(), this.ignoreMalformed()){
                final GeoPoint point;
                {
                    this.point = new GeoPoint();
                }

                @Override
                protected void writeValue(XContentBuilder b, long value) throws IOException {
                    this.point.reset(GeoEncodingUtils.decodeLatitude((int)(value >>> 32)), GeoEncodingUtils.decodeLongitude((int)value));
                    this.point.toXContent(b, ToXContent.EMPTY_PARAMS);
                }
            });
        }
        return super.syntheticSourceSupport();
    }

    public static final class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<GeoPoint> nullValue;
        final FieldMapper.Parameter<Boolean> indexed;
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).stored.get(), false);
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).script.get());
        private final FieldMapper.Parameter<OnScriptError> onScriptErrorParam = FieldMapper.Parameter.onScriptErrorParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).onScriptErrorParam.get(), this.script);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;
        private final IndexVersion indexCreatedVersion;
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> metric;
        private final FieldMapper.Parameter<Boolean> dimension;
        private final IndexMode indexMode;

        public Builder(String name, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault, IndexVersion indexCreatedVersion, IndexMode mode) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).nullValue.get(), (n, c, o) -> Builder.parseNullValue(o, this.ignoreZValue.get().value(), this.ignoreMalformed.get().value()), () -> null, XContentBuilder::field).acceptsNull();
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.indexCreatedVersion = Objects.requireNonNull(indexCreatedVersion);
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed, this.ignoreZValue);
            this.indexMode = mode;
            this.indexed = FieldMapper.Parameter.indexParam(m -> GeoPointFieldMapper.toType((FieldMapper)m).indexed, () -> this.indexMode != IndexMode.TIME_SERIES || this.getMetric().getValue() != TimeSeriesParams.MetricType.POSITION);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
            this.metric = TimeSeriesParams.metricParam(m -> GeoPointFieldMapper.toType((FieldMapper)m).metricType, TimeSeriesParams.MetricType.POSITION).addValidator(v -> {
                if (v != null && !this.hasDocValues.getValue().booleanValue()) {
                    throw new IllegalArgumentException("Field [time_series_metric] requires that [" + this.hasDocValues.name + "] is true");
                }
            });
            this.dimension = TimeSeriesParams.dimensionParam(m -> false).addValidator(v -> {
                if (v.booleanValue()) {
                    throw new IllegalArgumentException("Parameter [time_series_dimension] cannot be set to geo_point");
                }
            });
        }

        private FieldMapper.Parameter<TimeSeriesParams.MetricType> getMetric() {
            return this.metric;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.hasDocValues, this.indexed, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.script, this.onScriptErrorParam, this.meta, this.dimension, this.metric};
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        private static GeoPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            if (nullValue == null) {
                return null;
            }
            GeoPoint point = GeoUtils.parseGeoPoint(nullValue, ignoreZValue);
            if (!ignoreMalformed) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                }
                if (point.lon() > 180.0 || point.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                }
            } else {
                GeoUtils.normalizePoint(point);
            }
            return point;
        }

        private FieldValues<GeoPoint> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            GeoPointFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), GeoPointFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.leafName(), this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        public FieldMapper build(MapperBuilderContext context) {
            boolean ignoreMalformedEnabled = this.ignoreMalformed.get().value();
            GeoPointParser geoParser = new GeoPointParser(this.leafName(), parser -> GeoUtils.parseGeoPoint(parser, (boolean)this.ignoreZValue.get().value()), this.nullValue.get(), this.ignoreZValue.get().value(), ignoreMalformedEnabled, this.metric.get() != TimeSeriesParams.MetricType.POSITION, context.isSourceSynthetic() && ignoreMalformedEnabled);
            GeoPointFieldType ft = new GeoPointFieldType(context.buildFullName(this.leafName()), this.indexed.get() != false && !this.indexCreatedVersion.isLegacyIndexVersion(), this.stored.get(), this.hasDocValues.get(), geoParser, this.nullValue.get(), this.scriptValues(), this.meta.get(), this.metric.get(), this.indexMode, context.isSourceSynthetic());
            this.hasScript = this.script.get() != null;
            this.onScriptError = this.onScriptErrorParam.get();
            return new GeoPointFieldMapper(this.leafName(), ft, this.builderParams(this, context), geoParser, this);
        }
    }

    public static class LatLonPointWithDocValues
    extends Field {
        public static final FieldType TYPE = new FieldType();
        private final long docValue;

        public LatLonPointWithDocValues(String name, double latitude, double longitude) {
            super(name, TYPE);
            byte[] bytes;
            if (this.fieldsData == null) {
                bytes = new byte[8];
                this.fieldsData = new BytesRef(bytes);
            } else {
                bytes = ((BytesRef)this.fieldsData).bytes;
            }
            int latitudeEncoded = GeoEncodingUtils.encodeLatitude(latitude);
            int longitudeEncoded = GeoEncodingUtils.encodeLongitude(longitude);
            NumericUtils.intToSortableBytes(latitudeEncoded, bytes, 0);
            NumericUtils.intToSortableBytes(longitudeEncoded, bytes, 4);
            this.docValue = (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
        }

        @Override
        public Number numericValue() {
            return this.docValue;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.getClass().getSimpleName());
            result.append(" <");
            result.append(this.name);
            result.append(':');
            byte[] bytes = ((BytesRef)this.fieldsData).bytes;
            result.append(GeoEncodingUtils.decodeLatitude(bytes, 0));
            result.append(',');
            result.append(GeoEncodingUtils.decodeLongitude(bytes, 4));
            result.append('>');
            return result.toString();
        }

        static {
            TYPE.setDimensions(2, 4);
            TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
            TYPE.freeze();
        }
    }

    static class GeoHashMultiFieldParser
    extends FilterXContentParserWrapper {
        private final String value;

        GeoHashMultiFieldParser(XContentParser innerParser, String value) {
            super(innerParser);
            this.value = value;
        }

        @Override
        public XContentString optimizedTextOrNull() throws IOException {
            return new Text(this.value);
        }

        @Override
        public String textOrNull() throws IOException {
            return this.value;
        }

        @Override
        public String text() throws IOException {
            return this.value;
        }

        @Override
        public XContentParser.Token currentToken() {
            return XContentParser.Token.VALUE_STRING;
        }

        @Override
        public XContentParser.Token nextToken() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class GeoPointParser
    extends AbstractPointGeometryFieldMapper.PointParser<GeoPoint> {
        private final boolean storeMalformedDataForSyntheticSource;

        GeoPointParser(String field, CheckedFunction<XContentParser, GeoPoint, IOException> objectParser, GeoPoint nullValue, boolean ignoreZValue, boolean ignoreMalformed, boolean allowMultipleValues, boolean storeMalformedDataForSyntheticSource) {
            super(field, objectParser, nullValue, ignoreZValue, ignoreMalformed, allowMultipleValues);
            this.storeMalformedDataForSyntheticSource = storeMalformedDataForSyntheticSource;
        }

        @Override
        protected GeoPoint validate(GeoPoint in) {
            if (!this.ignoreMalformed) {
                if (in.lat() > 90.0 || in.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + in.lat() + "] for " + this.field);
                }
                if (in.lon() > 180.0 || in.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + in.lon() + "] for " + this.field);
                }
            } else if (GeoPointParser.isNormalizable(in.lat()) && GeoPointParser.isNormalizable(in.lon())) {
                GeoUtils.normalizePoint(in);
            } else {
                throw new ElasticsearchParseException("cannot normalize the point - not a number", new Object[0]);
            }
            return in;
        }

        private static boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }

        @Override
        protected GeoPoint createPoint(double x, double y) {
            return new GeoPoint(y, x);
        }

        @Override
        public GeoPoint normalizeFromSource(GeoPoint point) {
            return point;
        }

        @Override
        protected void parseAndConsumeFromObject(XContentParser parser, CheckedConsumer<GeoPoint, IOException> consumer, AbstractGeometryFieldMapper.MalformedValueHandler malformedHandler) throws IOException {
            XContentParser parserWithCustomization = parser;
            XContentBuilder malformedDataForSyntheticSource = null;
            if (this.storeMalformedDataForSyntheticSource) {
                if (parser.currentToken() == XContentParser.Token.START_OBJECT || parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    CopyingXContentParser copyingParser = new CopyingXContentParser(parser);
                    malformedDataForSyntheticSource = copyingParser.getBuilder();
                    parserWithCustomization = copyingParser;
                } else {
                    malformedDataForSyntheticSource = XContentBuilder.builder(parser.contentType().xContent()).copyCurrentStructure(parser);
                }
            }
            try {
                GeoPoint point = (GeoPoint)this.objectParser.apply(parserWithCustomization);
                consumer.accept(this.validate(point));
            }
            catch (Exception e) {
                malformedHandler.notify(e, malformedDataForSyntheticSource);
            }
        }
    }

    public static class GeoPointFieldType
    extends AbstractPointGeometryFieldMapper.AbstractPointFieldType<GeoPoint>
    implements GeoShapeQueryable {
        private final TimeSeriesParams.MetricType metricType;
        public static final GeoFormatterFactory<GeoPoint> GEO_FORMATTER_FACTORY = new GeoFormatterFactory(List.of(new SimpleVectorTileFormatter()));
        private final FieldValues<GeoPoint> scriptValues;
        private final IndexMode indexMode;
        private final boolean isSyntheticSource;

        private GeoPointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, AbstractGeometryFieldMapper.Parser<GeoPoint> parser, GeoPoint nullValue, FieldValues<GeoPoint> scriptValues, Map<String, String> meta, TimeSeriesParams.MetricType metricType, IndexMode indexMode, boolean isSyntheticSource) {
            super(name, indexed, stored, hasDocValues, parser, nullValue, meta);
            this.scriptValues = scriptValues;
            this.metricType = metricType;
            this.indexMode = indexMode;
            this.isSyntheticSource = isSyntheticSource;
        }

        public GeoPointFieldType(String name, TimeSeriesParams.MetricType metricType, IndexMode indexMode) {
            this(name, true, false, true, null, null, null, Collections.emptyMap(), metricType, indexMode, false);
        }

        public GeoPointFieldType(String name) {
            this(name, null, null);
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        @Override
        protected Function<List<GeoPoint>, List<Object>> getFormatter(String format) {
            return GEO_FORMATTER_FACTORY.getFormatter(format, p -> new org.elasticsearch.geometry.Point(p.getLon(), p.getLat()));
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (this.scriptValues == null) {
                return super.valueFetcher(context, format);
            }
            Function formatter = this.getFormatter(format != null ? format : "geojson");
            return FieldValues.valueListFetcher(this.scriptValues, formatter, context);
        }

        @Override
        public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
            Query query;
            this.failIfNotIndexedNorDocValuesFallback(context);
            ShapeField.QueryRelation luceneRelation = relation == ShapeRelation.INTERSECTS && GeoPointFieldType.isPointGeometry(geometries) ? ShapeField.QueryRelation.CONTAINS : relation.getLuceneRelation();
            if (this.isIndexed()) {
                query = LatLonPoint.newGeometryQuery(fieldName, luceneRelation, geometries);
                if (this.hasDocValues()) {
                    Query dvQuery = LatLonDocValuesField.newSlowGeometryQuery(fieldName, luceneRelation, geometries);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
            } else {
                query = LatLonDocValuesField.newSlowGeometryQuery(fieldName, luceneRelation, geometries);
            }
            return query;
        }

        private static boolean isPointGeometry(LatLonGeometry[] geometries) {
            return geometries.length == 1 && geometries[0] instanceof Point;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            CoreValuesSourceType valuesSourceType;
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            Enum enum_ = valuesSourceType = this.indexMode == IndexMode.TIME_SERIES && this.metricType == TimeSeriesParams.MetricType.POSITION ? TimeSeriesValuesSourceType.POSITION : CoreValuesSourceType.GEOPOINT;
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                return new LatLonPointIndexFieldData.Builder(this.name(), valuesSourceType, GeoPointDocValuesField::new);
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = fieldDataContext.lookupSupplier().get();
                Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
                return new SourceValueFetcherMultiGeoPointIndexFieldData.Builder(this.name(), (ValuesSourceType)valuesSourceType, this.valueFetcher(sourcePaths, null, null), (SourceProvider)searchLookup, GeoPointDocValuesField::new);
            }
            throw new IllegalStateException("unknown field data type [" + operation.name() + "]");
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            GeoPoint originGeoPoint;
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (origin instanceof GeoPoint) {
                originGeoPoint = (GeoPoint)origin;
            } else if (origin instanceof String) {
                originGeoPoint = GeoUtils.parseFromString((String)origin);
            } else {
                throw new IllegalArgumentException("Illegal type [" + String.valueOf(origin.getClass()) + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
            }
            double pivotDouble = DistanceUnit.DEFAULT.parse(pivot, DistanceUnit.DEFAULT);
            if (this.isIndexed()) {
                return LatLonPoint.newDistanceFeatureQuery(this.name(), 1.0f, originGeoPoint.lat(), originGeoPoint.lon(), pivotDouble);
            }
            return new GeoPointScriptFieldDistanceFeatureQuery(new Script(""), ctx -> new SortedNumericDocValuesLongFieldScript(this.name(), context.lookup(), (LeafReaderContext)ctx), this.name(), originGeoPoint.lat(), originGeoPoint.lon(), pivotDouble);
        }

        @Override
        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (blContext.fieldExtractPreference() == MappedFieldType.FieldExtractPreference.DOC_VALUES && this.hasDocValues()) {
                return new BlockDocValuesReader.LongsBlockLoader(this.name());
            }
            if (this.isSyntheticSource && !this.hasDocValues() && blContext.parentField(this.name()) == null) {
                return this.blockLoaderFromFallbackSyntheticSource(blContext);
            }
            return this.blockLoaderFromSource(blContext);
        }
    }
}

