/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.configuration;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;

public class AddVotingConfigExclusionsRequest
extends MasterNodeRequest<AddVotingConfigExclusionsRequest> {
    private final String[] nodeIds;
    private final String[] nodeNames;
    private final TimeValue timeout;

    public AddVotingConfigExclusionsRequest(TimeValue masterNodeTimeout, String ... nodeNames) {
        this(masterNodeTimeout, org.elasticsearch.common.Strings.EMPTY_ARRAY, nodeNames, TimeValue.timeValueSeconds(30L));
    }

    public AddVotingConfigExclusionsRequest(TimeValue masterNodeTimeout, String[] nodeIds, String[] nodeNames, TimeValue timeout) {
        super(masterNodeTimeout);
        if (timeout.compareTo(TimeValue.ZERO) < 0) {
            throw new IllegalArgumentException("timeout [" + String.valueOf(timeout) + "] must be non-negative");
        }
        if (nodeIds.length > 0 == nodeNames.length > 0) {
            throw new IllegalArgumentException("You must set [node_names] or [node_ids] but not both");
        }
        this.nodeIds = nodeIds;
        this.nodeNames = nodeNames;
        this.timeout = timeout;
    }

    public AddVotingConfigExclusionsRequest(StreamInput in) throws IOException {
        super(in);
        String[] legacyNodeDescriptions;
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (legacyNodeDescriptions = in.readStringArray()).length > 0) {
            throw new IllegalArgumentException("legacy [node_name] field was deprecated and must be empty");
        }
        this.nodeIds = in.readStringArray();
        this.nodeNames = in.readStringArray();
        this.timeout = in.readTimeValue();
        assert (this.nodeIds.length > 0 != this.nodeNames.length > 0);
    }

    Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusions(ClusterState currentState) {
        DiscoveryNodes allNodes = currentState.nodes();
        HashSet<CoordinationMetadata.VotingConfigExclusion> newVotingConfigExclusions = new HashSet<CoordinationMetadata.VotingConfigExclusion>();
        if (this.nodeIds.length > 0) {
            for (String nodeId : this.nodeIds) {
                if (allNodes.nodeExists(nodeId)) {
                    DiscoveryNode discoveryNode = allNodes.get(nodeId);
                    if (!discoveryNode.isMasterNode()) continue;
                    newVotingConfigExclusions.add(new CoordinationMetadata.VotingConfigExclusion(discoveryNode));
                    continue;
                }
                newVotingConfigExclusions.add(new CoordinationMetadata.VotingConfigExclusion(nodeId, "_absent_"));
            }
        } else {
            assert (this.nodeNames.length > 0);
            Map existingNodes = allNodes.stream().collect(Collectors.toMap(DiscoveryNode::getName, Function.identity(), (n1, n2) -> {
                throw new IllegalArgumentException(Strings.format("node name [%s] is ambiguous, matching [%s] and [%s]; specify node ID instead", n1.getName(), n1.descriptionWithoutAttributes(), n2.descriptionWithoutAttributes()));
            }));
            for (String nodeName : this.nodeNames) {
                if (existingNodes.containsKey(nodeName)) {
                    DiscoveryNode discoveryNode = (DiscoveryNode)existingNodes.get(nodeName);
                    if (!discoveryNode.isMasterNode()) continue;
                    newVotingConfigExclusions.add(new CoordinationMetadata.VotingConfigExclusion(discoveryNode));
                    continue;
                }
                newVotingConfigExclusions.add(new CoordinationMetadata.VotingConfigExclusion("_absent_", nodeName));
            }
        }
        newVotingConfigExclusions.removeIf(n -> currentState.getVotingConfigExclusions().contains(n));
        return newVotingConfigExclusions;
    }

    Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusionsAndCheckMaximum(ClusterState currentState, int maxExclusionsCount, String maximumSettingKey) {
        int newExclusionsCount;
        Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions = this.resolveVotingConfigExclusions(currentState);
        int oldExclusionsCount = currentState.getVotingConfigExclusions().size();
        if (oldExclusionsCount + (newExclusionsCount = resolvedExclusions.size()) > maxExclusionsCount) {
            throw new IllegalArgumentException("add voting config exclusions request for " + (this.nodeNames.length > 0 ? "nodes named " + String.valueOf(Arrays.asList(this.nodeNames)) : "nodes with ids " + String.valueOf(Arrays.asList(this.nodeIds))) + " would add [" + newExclusionsCount + "] exclusions to the existing [" + oldExclusionsCount + "] which would exceed the maximum of [" + maxExclusionsCount + "] set by [" + maximumSettingKey + "]");
        }
        return resolvedExclusions;
    }

    public String[] getNodeIds() {
        return this.nodeIds;
    }

    public String[] getNodeNames() {
        return this.nodeNames;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeStringArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
        }
        out.writeStringArray(this.nodeIds);
        out.writeStringArray(this.nodeNames);
        out.writeTimeValue(this.timeout);
    }

    @Override
    public String toString() {
        return "AddVotingConfigExclusionsRequest{nodeIds=" + String.valueOf(Arrays.asList(this.nodeIds)) + ", nodeNames=" + String.valueOf(Arrays.asList(this.nodeNames)) + ", timeout=" + String.valueOf(this.timeout) + "}";
    }
}

