/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.BooleanMatchingRule;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.GeneralizedTimeMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.persist.LDAPField;
import com.unboundid.ldap.sdk.persist.LDAPGetter;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.OIDAllocator;
import com.unboundid.ldap.sdk.persist.ObjectEncoder;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.persist.TypeInfo;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.AttributeUsage;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DefaultObjectEncoder
extends ObjectEncoder {
    private static final long serialVersionUID = -4566874784628920022L;

    @Override
    public boolean supportsType(@NotNull Type t) {
        TypeInfo typeInfo = new TypeInfo(t);
        if (!typeInfo.isSupported()) {
            return false;
        }
        Class<?> baseClass = typeInfo.getBaseClass();
        if (DefaultObjectEncoder.supportsTypeInternal(baseClass)) {
            return true;
        }
        Class<?> componentType = typeInfo.getComponentType();
        if (componentType == null) {
            return false;
        }
        if (typeInfo.isArray()) {
            return DefaultObjectEncoder.supportsTypeInternal(componentType);
        }
        if (typeInfo.isList()) {
            return DefaultObjectEncoder.isSupportedListType(baseClass) && DefaultObjectEncoder.supportsTypeInternal(componentType);
        }
        if (typeInfo.isSet()) {
            return DefaultObjectEncoder.isSupportedSetType(baseClass) && DefaultObjectEncoder.supportsTypeInternal(componentType);
        }
        return false;
    }

    private static boolean supportsTypeInternal(@NotNull Class<?> c) {
        Class<?> t;
        if (c.equals(AtomicInteger.class) || c.equals(AtomicLong.class) || c.equals(BigDecimal.class) || c.equals(BigInteger.class) || c.equals(Boolean.class) || c.equals(Boolean.TYPE) || c.equals(Date.class) || c.equals(DN.class) || c.equals(Double.class) || c.equals(Double.TYPE) || c.equals(Filter.class) || c.equals(Float.class) || c.equals(Float.TYPE) || c.equals(Integer.class) || c.equals(Integer.TYPE) || c.equals(LDAPURL.class) || c.equals(Long.class) || c.equals(Long.TYPE) || c.equals(RDN.class) || c.equals(Short.class) || c.equals(Short.TYPE) || c.equals(String.class) || c.equals(StringBuffer.class) || c.equals(StringBuilder.class) || c.equals(URI.class) || c.equals(URL.class) || c.equals(UUID.class)) {
            return true;
        }
        if (c.isArray() && ((t = c.getComponentType()).equals(Byte.TYPE) || t.equals(Character.TYPE))) {
            return true;
        }
        if (c.isEnum()) {
            return true;
        }
        if (Serializable.class.isAssignableFrom(c)) {
            return !c.isArray() && !Collection.class.isAssignableFrom(c);
        }
        return false;
    }

    private static boolean isSupportedListType(@NotNull Class<?> t) {
        return t.equals(List.class) || t.equals(ArrayList.class) || t.equals(LinkedList.class) || t.equals(CopyOnWriteArrayList.class);
    }

    @Nullable
    private static List<?> createList(@NotNull Class<?> t, int size) {
        if (t.equals(List.class) || t.equals(ArrayList.class)) {
            return new ArrayList(size);
        }
        if (t.equals(LinkedList.class)) {
            return new LinkedList();
        }
        if (t.equals(CopyOnWriteArrayList.class)) {
            return new CopyOnWriteArrayList();
        }
        return null;
    }

    private static boolean isSupportedSetType(@NotNull Class<?> t) {
        return t.equals(Set.class) || t.equals(HashSet.class) || t.equals(LinkedHashSet.class) || t.equals(TreeSet.class) || t.equals(CopyOnWriteArraySet.class);
    }

    @Nullable
    private static Set<?> createSet(@NotNull Class<?> t, int size) {
        if (t.equals(Set.class) || t.equals(LinkedHashSet.class)) {
            return new LinkedHashSet(StaticUtils.computeMapCapacity(size));
        }
        if (t.equals(HashSet.class)) {
            return new HashSet(StaticUtils.computeMapCapacity(size));
        }
        if (t.equals(TreeSet.class)) {
            return new TreeSet();
        }
        if (t.equals(CopyOnWriteArraySet.class)) {
            return new CopyOnWriteArraySet();
        }
        return null;
    }

    @Override
    @NotNull
    public AttributeTypeDefinition constructAttributeType(@NotNull Field f, @NotNull OIDAllocator a) throws LDAPPersistException {
        LDAPField at = f.getAnnotation(LDAPField.class);
        String attrName = at.attribute().isEmpty() ? f.getName() : at.attribute();
        String oid = a.allocateAttributeTypeOID(attrName);
        TypeInfo typeInfo = new TypeInfo(f.getGenericType());
        if (!typeInfo.isSupported()) {
            throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(String.valueOf(typeInfo.getType())));
        }
        boolean isSingleValued = !DefaultObjectEncoder.supportsMultipleValues(typeInfo);
        String syntaxOID = isSingleValued ? DefaultObjectEncoder.getSyntaxOID(typeInfo.getBaseClass()) : DefaultObjectEncoder.getSyntaxOID(typeInfo.getComponentType());
        MatchingRule mr = MatchingRule.selectMatchingRuleForSyntax(syntaxOID);
        return new AttributeTypeDefinition(oid, new String[]{attrName}, null, false, null, mr.getEqualityMatchingRuleNameOrOID(), mr.getOrderingMatchingRuleNameOrOID(), mr.getSubstringMatchingRuleNameOrOID(), syntaxOID, isSingleValued, false, false, AttributeUsage.USER_APPLICATIONS, null);
    }

    @Override
    @NotNull
    public AttributeTypeDefinition constructAttributeType(@NotNull Method m, @NotNull OIDAllocator a) throws LDAPPersistException {
        LDAPGetter at = m.getAnnotation(LDAPGetter.class);
        String attrName = at.attribute().isEmpty() ? StaticUtils.toInitialLowerCase(m.getName().substring(3)) : at.attribute();
        String oid = a.allocateAttributeTypeOID(attrName);
        TypeInfo typeInfo = new TypeInfo(m.getGenericReturnType());
        if (!typeInfo.isSupported()) {
            throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(String.valueOf(typeInfo.getType())));
        }
        boolean isSingleValued = !DefaultObjectEncoder.supportsMultipleValues(typeInfo);
        String syntaxOID = isSingleValued ? DefaultObjectEncoder.getSyntaxOID(typeInfo.getBaseClass()) : DefaultObjectEncoder.getSyntaxOID(typeInfo.getComponentType());
        return new AttributeTypeDefinition(oid, new String[]{attrName}, null, false, null, null, null, null, syntaxOID, isSingleValued, false, false, AttributeUsage.USER_APPLICATIONS, null);
    }

    @Nullable
    private static String getSyntaxOID(@NotNull Class<?> t) {
        if (t.equals(BigDecimal.class) || t.equals(Double.class) || t.equals(Double.TYPE) || t.equals(Float.class) || t.equals(Float.TYPE) || t.equals(String.class) || t.equals(StringBuffer.class) || t.equals(StringBuilder.class) || t.equals(URI.class) || t.equals(URL.class) || t.equals(Filter.class) || t.equals(LDAPURL.class)) {
            return "1.3.6.1.4.1.1466.115.121.1.15";
        }
        if (t.equals(AtomicInteger.class) || t.equals(AtomicLong.class) || t.equals(BigInteger.class) || t.equals(Integer.class) || t.equals(Integer.TYPE) || t.equals(Long.class) || t.equals(Long.TYPE) || t.equals(Short.class) || t.equals(Short.TYPE)) {
            return "1.3.6.1.4.1.1466.115.121.1.27";
        }
        if (t.equals(UUID.class)) {
            return "1.3.6.1.4.1.1466.115.121.1.15";
        }
        if (t.equals(DN.class) || t.equals(RDN.class)) {
            return "1.3.6.1.4.1.1466.115.121.1.12";
        }
        if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
            return "1.3.6.1.4.1.1466.115.121.1.7";
        }
        if (t.equals(Date.class)) {
            return "1.3.6.1.4.1.1466.115.121.1.24";
        }
        if (t.isArray()) {
            Class<?> ct = t.getComponentType();
            if (ct.equals(Byte.TYPE)) {
                return "1.3.6.1.4.1.1466.115.121.1.40";
            }
            if (ct.equals(Character.TYPE)) {
                return "1.3.6.1.4.1.1466.115.121.1.15";
            }
        } else {
            if (t.isEnum()) {
                return "1.3.6.1.4.1.1466.115.121.1.15";
            }
            if (Serializable.class.isAssignableFrom(t)) {
                return "1.3.6.1.4.1.1466.115.121.1.40";
            }
        }
        return null;
    }

    @Override
    public boolean supportsMultipleValues(@NotNull Field field) {
        return DefaultObjectEncoder.supportsMultipleValues(new TypeInfo(field.getGenericType()));
    }

    @Override
    public boolean supportsMultipleValues(@NotNull Method method) {
        Type[] paramTypes = method.getGenericParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        return DefaultObjectEncoder.supportsMultipleValues(new TypeInfo(paramTypes[0]));
    }

    private static boolean supportsMultipleValues(@NotNull TypeInfo t) {
        if (t.isArray()) {
            Class<?> componentType = t.getComponentType();
            return !componentType.equals(Byte.TYPE) && !componentType.equals(Character.TYPE);
        }
        return t.isMultiValued();
    }

    @Override
    @NotNull
    public Attribute encodeFieldValue(@NotNull Field field, @NotNull Object value, @NotNull String name) throws LDAPPersistException {
        return DefaultObjectEncoder.encodeValue(field.getGenericType(), value, name);
    }

    @Override
    @NotNull
    public Attribute encodeMethodValue(@NotNull Method method, @NotNull Object value, @NotNull String name) throws LDAPPersistException {
        return DefaultObjectEncoder.encodeValue(method.getGenericReturnType(), value, name);
    }

    @NotNull
    private static Attribute encodeValue(@NotNull Type type, @NotNull Object value, @NotNull String name) throws LDAPPersistException {
        TypeInfo typeInfo = new TypeInfo(type);
        Class<?> c = typeInfo.getBaseClass();
        if (c.equals(AtomicInteger.class) || c.equals(AtomicLong.class) || c.equals(BigDecimal.class) || c.equals(BigInteger.class) || c.equals(Double.class) || c.equals(Double.TYPE) || c.equals(Float.class) || c.equals(Float.TYPE) || c.equals(Integer.class) || c.equals(Integer.TYPE) || c.equals(Long.class) || c.equals(Long.TYPE) || c.equals(Short.class) || c.equals(Short.TYPE) || c.equals(String.class) || c.equals(StringBuffer.class) || c.equals(StringBuilder.class) || c.equals(UUID.class) || c.equals(DN.class) || c.equals(Filter.class) || c.equals(LDAPURL.class) || c.equals(RDN.class)) {
            String syntaxOID = DefaultObjectEncoder.getSyntaxOID(c);
            MatchingRule matchingRule = MatchingRule.selectMatchingRuleForSyntax(syntaxOID);
            return new Attribute(name, matchingRule, String.valueOf(value));
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            return new Attribute(name, uri.toASCIIString());
        }
        if (value instanceof URL) {
            URL url = (URL)value;
            return new Attribute(name, url.toExternalForm());
        }
        if (value instanceof byte[]) {
            return new Attribute(name, (MatchingRule)OctetStringMatchingRule.getInstance(), (byte[])value);
        }
        if (value instanceof char[]) {
            return new Attribute(name, new String((char[])value));
        }
        if (c.equals(Boolean.class) || c.equals(Boolean.TYPE)) {
            Boolean b = (Boolean)value;
            BooleanMatchingRule matchingRule = BooleanMatchingRule.getInstance();
            if (b.booleanValue()) {
                return new Attribute(name, (MatchingRule)matchingRule, "TRUE");
            }
            return new Attribute(name, (MatchingRule)matchingRule, "FALSE");
        }
        if (c.equals(Date.class)) {
            Date d = (Date)value;
            return new Attribute(name, (MatchingRule)GeneralizedTimeMatchingRule.getInstance(), StaticUtils.encodeGeneralizedTime(d));
        }
        if (typeInfo.isArray()) {
            return DefaultObjectEncoder.encodeArray(typeInfo.getComponentType(), value, name);
        }
        if (typeInfo.isEnum()) {
            Enum e = (Enum)value;
            return new Attribute(name, e.name());
        }
        if (Collection.class.isAssignableFrom(c)) {
            return DefaultObjectEncoder.encodeCollection(typeInfo.getComponentType(), (Collection)value, name);
        }
        if (Serializable.class.isAssignableFrom(c)) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                oos.close();
                return new Attribute(name, (MatchingRule)OctetStringMatchingRule.getInstance(), baos.toByteArray());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_CANNOT_SERIALIZE.get(name, StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        }
        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(String.valueOf(type)));
    }

    @NotNull
    private static Attribute encodeArray(@NotNull Class<?> arrayType, @NotNull Object arrayObject, @NotNull String attributeName) throws LDAPPersistException {
        ASN1OctetString[] values = new ASN1OctetString[Array.getLength(arrayObject)];
        AtomicReference<MatchingRule> matchingRule = new AtomicReference<MatchingRule>();
        for (int i = 0; i < values.length; ++i) {
            Object o = Array.get(arrayObject, i);
            if (arrayType.equals(AtomicInteger.class) || arrayType.equals(AtomicLong.class) || arrayType.equals(BigDecimal.class) || arrayType.equals(BigInteger.class) || arrayType.equals(Double.class) || arrayType.equals(Double.TYPE) || arrayType.equals(Float.class) || arrayType.equals(Float.TYPE) || arrayType.equals(Integer.class) || arrayType.equals(Integer.TYPE) || arrayType.equals(Long.class) || arrayType.equals(Long.TYPE) || arrayType.equals(Short.class) || arrayType.equals(Short.TYPE) || arrayType.equals(String.class) || arrayType.equals(StringBuffer.class) || arrayType.equals(StringBuilder.class) || arrayType.equals(UUID.class) || arrayType.equals(DN.class) || arrayType.equals(Filter.class) || arrayType.equals(LDAPURL.class) || arrayType.equals(RDN.class)) {
                if (matchingRule.get() == null) {
                    String syntaxOID = DefaultObjectEncoder.getSyntaxOID(arrayType);
                    matchingRule.set(MatchingRule.selectMatchingRuleForSyntax(syntaxOID));
                }
                values[i] = new ASN1OctetString(String.valueOf(o));
                continue;
            }
            if (arrayType.equals(URI.class)) {
                URI uri = (URI)o;
                values[i] = new ASN1OctetString(uri.toASCIIString());
                continue;
            }
            if (arrayType.equals(URL.class)) {
                URL url = (URL)o;
                values[i] = new ASN1OctetString(url.toExternalForm());
                continue;
            }
            if (o instanceof byte[]) {
                matchingRule.compareAndSet(null, OctetStringMatchingRule.getInstance());
                values[i] = new ASN1OctetString((byte[])o);
                continue;
            }
            if (o instanceof char[]) {
                values[i] = new ASN1OctetString(new String((char[])o));
                continue;
            }
            if (arrayType.equals(Boolean.class) || arrayType.equals(Boolean.TYPE)) {
                matchingRule.compareAndSet(null, BooleanMatchingRule.getInstance());
                Boolean b = (Boolean)o;
                if (b.booleanValue()) {
                    values[i] = new ASN1OctetString("TRUE");
                    continue;
                }
                values[i] = new ASN1OctetString("FALSE");
                continue;
            }
            if (arrayType.equals(Date.class)) {
                matchingRule.compareAndSet(null, GeneralizedTimeMatchingRule.getInstance());
                Date d = (Date)o;
                values[i] = new ASN1OctetString(StaticUtils.encodeGeneralizedTime(d));
                continue;
            }
            if (arrayType.isEnum()) {
                Enum e = (Enum)o;
                values[i] = new ASN1OctetString(e.name());
                continue;
            }
            if (Serializable.class.isAssignableFrom(arrayType)) {
                matchingRule.compareAndSet(null, OctetStringMatchingRule.getInstance());
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(o);
                    oos.close();
                    values[i] = new ASN1OctetString(baos.toByteArray());
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_CANNOT_SERIALIZE.get(attributeName, StaticUtils.getExceptionMessage(e)), (Throwable)e);
                }
            }
            throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(arrayType.getName()));
        }
        matchingRule.compareAndSet(null, CaseIgnoreStringMatchingRule.getInstance());
        return new Attribute(attributeName, (MatchingRule)matchingRule.get(), values);
    }

    @NotNull
    private static Attribute encodeCollection(@NotNull Class<?> genericType, @NotNull Collection<?> collection, @NotNull String attributeName) throws LDAPPersistException {
        ASN1OctetString[] values = new ASN1OctetString[collection.size()];
        AtomicReference<MatchingRule> matchingRule = new AtomicReference<MatchingRule>();
        int i = 0;
        for (Object o : collection) {
            if (genericType.equals(AtomicInteger.class) || genericType.equals(AtomicLong.class) || genericType.equals(BigDecimal.class) || genericType.equals(BigInteger.class) || genericType.equals(Double.class) || genericType.equals(Double.TYPE) || genericType.equals(Float.class) || genericType.equals(Float.TYPE) || genericType.equals(Integer.class) || genericType.equals(Integer.TYPE) || genericType.equals(Long.class) || genericType.equals(Long.TYPE) || genericType.equals(Short.class) || genericType.equals(Short.TYPE) || genericType.equals(String.class) || genericType.equals(StringBuffer.class) || genericType.equals(StringBuilder.class) || genericType.equals(UUID.class) || genericType.equals(DN.class) || genericType.equals(Filter.class) || genericType.equals(LDAPURL.class) || genericType.equals(RDN.class)) {
                if (matchingRule.get() == null) {
                    String syntaxOID = DefaultObjectEncoder.getSyntaxOID(genericType);
                    matchingRule.set(MatchingRule.selectMatchingRuleForSyntax(syntaxOID));
                }
                values[i] = new ASN1OctetString(String.valueOf(o));
            } else if (genericType.equals(URI.class)) {
                URI uri = (URI)o;
                values[i] = new ASN1OctetString(uri.toASCIIString());
            } else if (genericType.equals(URL.class)) {
                URL url = (URL)o;
                values[i] = new ASN1OctetString(url.toExternalForm());
            } else if (o instanceof byte[]) {
                matchingRule.compareAndSet(null, OctetStringMatchingRule.getInstance());
                values[i] = new ASN1OctetString((byte[])o);
            } else if (o instanceof char[]) {
                values[i] = new ASN1OctetString(new String((char[])o));
            } else if (genericType.equals(Boolean.class) || genericType.equals(Boolean.TYPE)) {
                matchingRule.compareAndSet(null, BooleanMatchingRule.getInstance());
                Boolean b = (Boolean)o;
                values[i] = b.booleanValue() ? new ASN1OctetString("TRUE") : new ASN1OctetString("FALSE");
            } else if (genericType.equals(Date.class)) {
                matchingRule.compareAndSet(null, GeneralizedTimeMatchingRule.getInstance());
                Date d = (Date)o;
                values[i] = new ASN1OctetString(StaticUtils.encodeGeneralizedTime(d));
            } else if (genericType.isEnum()) {
                Enum e = (Enum)o;
                values[i] = new ASN1OctetString(e.name());
            } else if (Serializable.class.isAssignableFrom(genericType)) {
                matchingRule.compareAndSet(null, OctetStringMatchingRule.getInstance());
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(o);
                    oos.close();
                    values[i] = new ASN1OctetString(baos.toByteArray());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_CANNOT_SERIALIZE.get(attributeName, StaticUtils.getExceptionMessage(e)), (Throwable)e);
                }
            } else {
                throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(genericType.getName()));
            }
            ++i;
        }
        matchingRule.compareAndSet(null, CaseIgnoreStringMatchingRule.getInstance());
        return new Attribute(attributeName, (MatchingRule)matchingRule.get(), values);
    }

    @Override
    public void decodeField(@NotNull Field field, @NotNull Object object, @NotNull Attribute attribute) throws LDAPPersistException {
        field.setAccessible(true);
        TypeInfo typeInfo = new TypeInfo(field.getGenericType());
        try {
            Class<?> baseClass = typeInfo.getBaseClass();
            Object newValue = DefaultObjectEncoder.getValue(baseClass, attribute, 0);
            if (newValue != null) {
                field.set(object, newValue);
                return;
            }
            if (typeInfo.isArray()) {
                Class<?> componentType = typeInfo.getComponentType();
                ASN1OctetString[] values = attribute.getRawValues();
                Object arrayObject = Array.newInstance(componentType, values.length);
                for (int i = 0; i < values.length; ++i) {
                    Object o = DefaultObjectEncoder.getValue(componentType, attribute, i);
                    if (o == null) {
                        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(componentType.getName()));
                    }
                    Array.set(arrayObject, i, o);
                }
                field.set(object, arrayObject);
                return;
            }
            if (typeInfo.isList() && DefaultObjectEncoder.isSupportedListType(baseClass)) {
                Class<?> componentType = typeInfo.getComponentType();
                if (componentType == null) {
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(baseClass.getName()));
                }
                ASN1OctetString[] values = attribute.getRawValues();
                List<?> l = DefaultObjectEncoder.createList(baseClass, values.length);
                for (int i = 0; i < values.length; ++i) {
                    Object o = DefaultObjectEncoder.getValue(componentType, attribute, i);
                    if (o == null) {
                        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(componentType.getName()));
                    }
                    DefaultObjectEncoder.invokeAdd(l, o);
                }
                field.set(object, l);
                return;
            }
            if (typeInfo.isSet() && DefaultObjectEncoder.isSupportedSetType(baseClass)) {
                Class<?> componentType = typeInfo.getComponentType();
                if (componentType == null) {
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(baseClass.getName()));
                }
                ASN1OctetString[] values = attribute.getRawValues();
                Set<?> l = DefaultObjectEncoder.createSet(baseClass, values.length);
                for (int i = 0; i < values.length; ++i) {
                    Object o = DefaultObjectEncoder.getValue(componentType, attribute, i);
                    if (o == null) {
                        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(componentType.getName()));
                    }
                    DefaultObjectEncoder.invokeAdd(l, o);
                }
                field.set(object, l);
                return;
            }
            throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(baseClass.getName()));
        }
        catch (LDAPPersistException lpe) {
            Debug.debugException(lpe);
            throw lpe;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPPersistException(StaticUtils.getExceptionMessage(e), (Throwable)e);
        }
    }

    @Override
    public void invokeSetter(@NotNull Method method, @NotNull Object object, @NotNull Attribute attribute) throws LDAPPersistException {
        TypeInfo typeInfo = new TypeInfo(method.getGenericParameterTypes()[0]);
        Class<?> baseClass = typeInfo.getBaseClass();
        method.setAccessible(true);
        try {
            Object newValue = DefaultObjectEncoder.getValue(baseClass, attribute, 0);
            if (newValue != null) {
                method.invoke(object, newValue);
                return;
            }
            if (typeInfo.isArray()) {
                Class<?> componentType = typeInfo.getComponentType();
                ASN1OctetString[] values = attribute.getRawValues();
                Object arrayObject = Array.newInstance(componentType, values.length);
                for (int i = 0; i < values.length; ++i) {
                    Object o = DefaultObjectEncoder.getValue(componentType, attribute, i);
                    if (o == null) {
                        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(componentType.getName()));
                    }
                    Array.set(arrayObject, i, o);
                }
                method.invoke(object, arrayObject);
                return;
            }
            if (typeInfo.isList() && DefaultObjectEncoder.isSupportedListType(baseClass)) {
                Class<?> componentType = typeInfo.getComponentType();
                if (componentType == null) {
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(baseClass.getName()));
                }
                ASN1OctetString[] values = attribute.getRawValues();
                List<?> l = DefaultObjectEncoder.createList(baseClass, values.length);
                for (int i = 0; i < values.length; ++i) {
                    Object o = DefaultObjectEncoder.getValue(componentType, attribute, i);
                    if (o == null) {
                        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(componentType.getName()));
                    }
                    DefaultObjectEncoder.invokeAdd(l, o);
                }
                method.invoke(object, l);
                return;
            }
            if (typeInfo.isSet() && DefaultObjectEncoder.isSupportedSetType(baseClass)) {
                Class<?> componentType = typeInfo.getComponentType();
                if (componentType == null) {
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(baseClass.getName()));
                }
                ASN1OctetString[] values = attribute.getRawValues();
                Set<?> s = DefaultObjectEncoder.createSet(baseClass, values.length);
                for (int i = 0; i < values.length; ++i) {
                    Object o = DefaultObjectEncoder.getValue(componentType, attribute, i);
                    if (o == null) {
                        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(componentType.getName()));
                    }
                    DefaultObjectEncoder.invokeAdd(s, o);
                }
                method.invoke(object, s);
                return;
            }
            throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_UNSUPPORTED_TYPE.get(baseClass.getName()));
        }
        catch (LDAPPersistException lpe) {
            Debug.debugException(lpe);
            throw lpe;
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                throw new LDAPPersistException(StaticUtils.getExceptionMessage(targetException), targetException);
            }
            throw new LDAPPersistException(StaticUtils.getExceptionMessage(e), (Throwable)e);
        }
    }

    @Nullable
    private static Object getValue(@NotNull Class<?> t, @NotNull Attribute a, int p) throws LDAPPersistException {
        ASN1OctetString v = a.getRawValues()[p];
        if (t.equals(AtomicInteger.class)) {
            return new AtomicInteger(Integer.valueOf(v.stringValue()));
        }
        if (t.equals(AtomicLong.class)) {
            return new AtomicLong(Long.valueOf(v.stringValue()));
        }
        if (t.equals(BigDecimal.class)) {
            return new BigDecimal(v.stringValue());
        }
        if (t.equals(BigInteger.class)) {
            return new BigInteger(v.stringValue());
        }
        if (t.equals(Double.class) || t.equals(Double.TYPE)) {
            return Double.valueOf(v.stringValue());
        }
        if (t.equals(Float.class) || t.equals(Float.TYPE)) {
            return Float.valueOf(v.stringValue());
        }
        if (t.equals(Integer.class) || t.equals(Integer.TYPE)) {
            return Integer.valueOf(v.stringValue());
        }
        if (t.equals(Long.class) || t.equals(Long.TYPE)) {
            return Long.valueOf(v.stringValue());
        }
        if (t.equals(Short.class) || t.equals(Short.TYPE)) {
            return Short.valueOf(v.stringValue());
        }
        if (t.equals(String.class)) {
            return String.valueOf(v.stringValue());
        }
        if (t.equals(StringBuffer.class)) {
            return new StringBuffer(v.stringValue());
        }
        if (t.equals(StringBuilder.class)) {
            return new StringBuilder(v.stringValue());
        }
        if (t.equals(URI.class)) {
            try {
                return new URI(v.stringValue());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_VALUE_INVALID_URI.get(v.stringValue(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        }
        if (t.equals(URL.class)) {
            try {
                return new URL(v.stringValue());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_VALUE_INVALID_URL.get(v.stringValue(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        }
        if (t.equals(UUID.class)) {
            try {
                return UUID.fromString(v.stringValue());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_VALUE_INVALID_UUID.get(v.stringValue(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        }
        if (t.equals(DN.class)) {
            try {
                return new DN(v.stringValue());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPPersistException(le.getMessage(), (Throwable)le);
            }
        }
        if (t.equals(Filter.class)) {
            try {
                return Filter.create(v.stringValue());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPPersistException(le.getMessage(), (Throwable)le);
            }
        }
        if (t.equals(LDAPURL.class)) {
            try {
                return new LDAPURL(v.stringValue());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPPersistException(le.getMessage(), (Throwable)le);
            }
        }
        if (t.equals(RDN.class)) {
            try {
                return new RDN(v.stringValue());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPPersistException(le.getMessage(), (Throwable)le);
            }
        }
        if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
            String s = v.stringValue();
            if (s.equalsIgnoreCase("TRUE")) {
                return Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("FALSE")) {
                return Boolean.FALSE;
            }
            throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_VALUE_INVALID_BOOLEAN.get(s));
        }
        if (t.equals(Date.class)) {
            try {
                return StaticUtils.decodeGeneralizedTime(v.stringValue());
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_VALUE_INVALID_DATE.get(v.stringValue(), e.getMessage()), (Throwable)e);
            }
        }
        if (t.isArray()) {
            Class<?> componentType = t.getComponentType();
            if (componentType.equals(Byte.TYPE)) {
                return v.getValue();
            }
            if (componentType.equals(Character.TYPE)) {
                return v.stringValue().toCharArray();
            }
        } else {
            if (t.isEnum()) {
                try {
                    Class<?> enumClass = t;
                    return Enum.valueOf(enumClass, v.stringValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_VALUE_INVALID_ENUM.get(v.stringValue(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
                }
            }
            if (Serializable.class.isAssignableFrom(t)) {
                if (t.isArray() || Collection.class.isAssignableFrom(t)) {
                    return null;
                }
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(v.getValue());
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    Object o = ois.readObject();
                    ois.close();
                    return o;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_CANNOT_DESERIALIZE.get(a.getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static void invokeAdd(@NotNull Object l, @NotNull Object o) throws LDAPPersistException {
        Class<?> c = l.getClass();
        for (Method m : c.getMethods()) {
            if (!m.getName().equals("add") || m.getGenericParameterTypes().length != 1) continue;
            try {
                m.invoke(l, o);
                return;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_CANNOT_ADD.get(StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        }
        throw new LDAPPersistException(PersistMessages.ERR_DEFAULT_ENCODER_CANNOT_FIND_ADD_METHOD.get());
    }
}

