/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.SynonymFormat;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import javax.annotation.Nullable;

public abstract class SynonymTokenFilterBase
extends TokenFilterBase {
    @Nullable
    private final Boolean expand;
    @Nullable
    private final SynonymFormat format;
    @Nullable
    private final Boolean lenient;
    private final List<String> synonyms;
    @Nullable
    private final String synonymsPath;
    @Nullable
    private final String synonymsSet;
    @Nullable
    private final String tokenizer;
    @Nullable
    private final Boolean updateable;

    protected SynonymTokenFilterBase(AbstractBuilder<?> builder) {
        super(builder);
        this.expand = ((AbstractBuilder)builder).expand;
        this.format = ((AbstractBuilder)builder).format;
        this.lenient = ((AbstractBuilder)builder).lenient;
        this.synonyms = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).synonyms);
        this.synonymsPath = ((AbstractBuilder)builder).synonymsPath;
        this.synonymsSet = ((AbstractBuilder)builder).synonymsSet;
        this.tokenizer = ((AbstractBuilder)builder).tokenizer;
        this.updateable = ((AbstractBuilder)builder).updateable;
    }

    @Nullable
    public final Boolean expand() {
        return this.expand;
    }

    @Nullable
    public final SynonymFormat format() {
        return this.format;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    public final List<String> synonyms() {
        return this.synonyms;
    }

    @Nullable
    public final String synonymsPath() {
        return this.synonymsPath;
    }

    @Nullable
    public final String synonymsSet() {
        return this.synonymsSet;
    }

    @Deprecated
    @Nullable
    public final String tokenizer() {
        return this.tokenizer;
    }

    @Nullable
    public final Boolean updateable() {
        return this.updateable;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.expand != null) {
            generator.writeKey("expand");
            generator.write(this.expand);
        }
        if (this.format != null) {
            generator.writeKey("format");
            this.format.serialize(generator, mapper);
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient);
        }
        if (ApiTypeHelper.isDefined(this.synonyms)) {
            generator.writeKey("synonyms");
            generator.writeStartArray();
            for (String item0 : this.synonyms) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.synonymsPath != null) {
            generator.writeKey("synonyms_path");
            generator.write(this.synonymsPath);
        }
        if (this.synonymsSet != null) {
            generator.writeKey("synonyms_set");
            generator.write(this.synonymsSet);
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            generator.write(this.tokenizer);
        }
        if (this.updateable != null) {
            generator.writeKey("updateable");
            generator.write(this.updateable);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSynonymTokenFilterBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(AbstractBuilder::expand, JsonpDeserializer.booleanDeserializer(), "expand");
        op.add(AbstractBuilder::format, SynonymFormat._DESERIALIZER, "format");
        op.add(AbstractBuilder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient");
        op.add(AbstractBuilder::synonyms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "synonyms");
        op.add(AbstractBuilder::synonymsPath, JsonpDeserializer.stringDeserializer(), "synonyms_path");
        op.add(AbstractBuilder::synonymsSet, JsonpDeserializer.stringDeserializer(), "synonyms_set");
        op.add(AbstractBuilder::tokenizer, JsonpDeserializer.stringDeserializer(), "tokenizer");
        op.add(AbstractBuilder::updateable, JsonpDeserializer.booleanDeserializer(), "updateable");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends TokenFilterBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Boolean expand;
        @Nullable
        private SynonymFormat format;
        @Nullable
        private Boolean lenient;
        @Nullable
        private List<String> synonyms;
        @Nullable
        private String synonymsPath;
        @Nullable
        private String synonymsSet;
        @Nullable
        private String tokenizer;
        @Nullable
        private Boolean updateable;

        public final BuilderT expand(@Nullable Boolean value) {
            this.expand = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT format(@Nullable SynonymFormat value) {
            this.format = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT lenient(@Nullable Boolean value) {
            this.lenient = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT synonyms(List<String> list) {
            this.synonyms = AbstractBuilder._listAddAll(this.synonyms, list);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT synonyms(String value, String ... values) {
            this.synonyms = AbstractBuilder._listAdd(this.synonyms, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT synonymsPath(@Nullable String value) {
            this.synonymsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT synonymsSet(@Nullable String value) {
            this.synonymsSet = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Deprecated
        public final BuilderT tokenizer(@Nullable String value) {
            this.tokenizer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT updateable(@Nullable Boolean value) {
            this.updateable = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

